/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder.rewriters;

import java.util.Map;
import org.apache.jena.arq.querybuilder.rewriters.AbstractRewriter;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.NodeValueBoolean;
import org.apache.jena.sparql.expr.nodevalue.NodeValueDT;
import org.apache.jena.sparql.expr.nodevalue.NodeValueDecimal;
import org.apache.jena.sparql.expr.nodevalue.NodeValueDouble;
import org.apache.jena.sparql.expr.nodevalue.NodeValueDuration;
import org.apache.jena.sparql.expr.nodevalue.NodeValueFloat;
import org.apache.jena.sparql.expr.nodevalue.NodeValueInteger;
import org.apache.jena.sparql.expr.nodevalue.NodeValueLang;
import org.apache.jena.sparql.expr.nodevalue.NodeValueNode;
import org.apache.jena.sparql.expr.nodevalue.NodeValueString;
import org.apache.jena.sparql.expr.nodevalue.NodeValueVisitor;

class NodeValueRewriter
extends AbstractRewriter<NodeValue>
implements NodeValueVisitor {
    public NodeValueRewriter(Map<Var, Node> values) {
        super(values);
    }

    public void visit(NodeValueBoolean nv) {
        this.push(new NodeValueBoolean(nv.getBoolean(), this.changeNode(nv.getNode())));
    }

    public void visit(NodeValueDecimal nv) {
        this.push(new NodeValueDecimal(nv.getDecimal(), this.changeNode(nv.getNode())));
    }

    public void visit(NodeValueDouble nv) {
        this.push(new NodeValueDouble(nv.getDouble(), this.changeNode(nv.getNode())));
    }

    public void visit(NodeValueFloat nv) {
        this.push(new NodeValueFloat(nv.getFloat(), this.changeNode(nv.getNode())));
    }

    public void visit(NodeValueInteger nv) {
        this.push(new NodeValueInteger(nv.getInteger(), this.changeNode(nv.getNode())));
    }

    public void visit(NodeValueNode nv) {
        this.push(new NodeValueNode(this.changeNode(nv.getNode())));
    }

    public void visit(NodeValueString nv) {
        this.push(new NodeValueString(nv.getString(), this.changeNode(nv.getNode())));
    }

    public void visit(NodeValueDT nv) {
        this.push(new NodeValueDT(nv.getDateTime().toXMLFormat(), this.changeNode(nv.getNode())));
    }

    public void visit(NodeValueDuration nodeValueDuration) {
        this.push(new NodeValueDuration(nodeValueDuration.getDuration(), this.changeNode(nodeValueDuration.getNode())));
    }

    public void visit(NodeValueLang nv) {
        this.push(new NodeValueLang(this.changeNode(nv.getNode())));
    }
}

