/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder.rewriters;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.jena.arq.querybuilder.rewriters.PathRewriter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprLib;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathVisitor;

public class AbstractRewriter<T> {
    protected final Map<Var, Node> values;
    private final Stack<T> result = new Stack();

    protected AbstractRewriter(Map<Var, Node> values) {
        this.values = values;
    }

    protected final void push(T value) {
        this.result.push(value);
    }

    protected final T pop() {
        return this.result.pop();
    }

    protected final boolean isEmpty() {
        return this.result.isEmpty();
    }

    public final T getResult() {
        if (this.isEmpty()) {
            return null;
        }
        return this.pop();
    }

    protected final TriplePath rewrite(TriplePath t) {
        if (t.getPath() == null) {
            return new TriplePath(Triple.create((Node)this.changeNode(t.getSubject()), (Node)this.changeNode(t.getPredicate()), (Node)this.changeNode(t.getObject())));
        }
        PathRewriter transform = new PathRewriter(this.values);
        t.getPath().visit((PathVisitor)transform);
        return new TriplePath(this.changeNode(t.getSubject()), (Path)transform.getResult(), this.changeNode(t.getObject()));
    }

    protected final Triple rewrite(Triple t) {
        return Triple.create((Node)this.changeNode(t.getSubject()), (Node)this.changeNode(t.getPredicate()), (Node)this.changeNode(t.getObject()));
    }

    protected final Node changeNode(Node n) {
        if (n == null) {
            return n;
        }
        if (n.isVariable()) {
            Var v = Var.alloc((Node)n);
            if (this.values.containsKey(v)) {
                return this.values.get(v);
            }
            return v;
        }
        return n;
    }

    protected final List<Node> changeNodes(List<Node> src) {
        ArrayList<Node> lst = new ArrayList<Node>();
        for (Node t : src) {
            lst.add(this.changeNode(t));
        }
        return lst;
    }

    public final List<Triple> rewrite(List<Triple> src) {
        ArrayList<Triple> lst = new ArrayList<Triple>();
        for (Triple t : src) {
            lst.add(this.rewrite(t));
        }
        return lst;
    }

    protected final Binding rewrite(Binding binding) {
        BindingBuilder builder = Binding.builder();
        Iterator iter = binding.vars();
        while (iter.hasNext()) {
            Var v = (Var)iter.next();
            Node n = this.changeNode(binding.get(v));
            n = n.equals((Object)v) ? binding.get(v) : n;
            builder.add(v, n);
        }
        return builder.build();
    }

    public final VarExprList rewrite(VarExprList lst) {
        VarExprList retval = new VarExprList();
        for (Var var : lst.getVars()) {
            Node n = this.values.get(var);
            if (n != null) {
                if (!n.isVariable()) continue;
                retval.add(Var.alloc((Node)n));
                continue;
            }
            retval.add(var);
        }
        for (Map.Entry entry : lst.getExprs().entrySet()) {
            Expr target = ExprLib.nodeToExpr((Node)((Node)entry.getKey()));
            Node n = this.values.get(entry.getKey());
            Var v = (Var)entry.getKey();
            Expr e = (Expr)entry.getValue();
            if (n != null) {
                if (n.isVariable()) {
                    v = Var.alloc((Node)n);
                    if (target.equals((Object)e)) {
                        e = ExprLib.nodeToExpr((Node)n);
                    }
                } else {
                    v = null;
                }
            }
            if (v == null) continue;
            retval.add(v, e);
        }
        return retval;
    }
}

