/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.jena.arq.querybuilder.AbstractQueryBuilder;
import org.apache.jena.arq.querybuilder.Converters;
import org.apache.jena.arq.querybuilder.Order;
import org.apache.jena.arq.querybuilder.clauses.DatasetClause;
import org.apache.jena.arq.querybuilder.clauses.SelectClause;
import org.apache.jena.arq.querybuilder.clauses.SolutionModifierClause;
import org.apache.jena.arq.querybuilder.clauses.WhereClause;
import org.apache.jena.arq.querybuilder.handlers.DatasetHandler;
import org.apache.jena.arq.querybuilder.handlers.HandlerBlock;
import org.apache.jena.arq.querybuilder.handlers.SelectHandler;
import org.apache.jena.arq.querybuilder.handlers.SolutionModifierHandler;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;

public class SelectBuilder
extends AbstractQueryBuilder<SelectBuilder>
implements DatasetClause<SelectBuilder>,
WhereClause<SelectBuilder>,
SolutionModifierClause<SelectBuilder>,
SelectClause<SelectBuilder> {
    private final HandlerBlock handlerBlock;

    public SelectBuilder() {
        this.query.setQuerySelectType();
        this.handlerBlock = new HandlerBlock(this.query);
    }

    @Override
    public DatasetHandler getDatasetHandler() {
        return this.handlerBlock.getDatasetHandler();
    }

    @Override
    public HandlerBlock getHandlerBlock() {
        return this.handlerBlock;
    }

    public SelectBuilder clone() {
        SelectBuilder qb = new SelectBuilder();
        qb.handlerBlock.addAll(this.handlerBlock);
        return qb;
    }

    public SelectBuilder setDistinct(boolean state) {
        this.getSelectHandler().setDistinct(state);
        return this;
    }

    public SelectBuilder setReduced(boolean state) {
        this.getSelectHandler().setReduced(state);
        return this;
    }

    @Override
    public SelectBuilder addVar(Object var) {
        this.getSelectHandler().addVar(Converters.makeVar(var));
        return this;
    }

    @Override
    public SelectBuilder addVar(String expression, Object var) {
        this.getSelectHandler().addVar(expression, Converters.makeVar(var));
        return this;
    }

    @Override
    public SelectBuilder addVar(Expr expr, Object var) {
        this.getSelectHandler().addVar(expr, Converters.makeVar(var));
        return this;
    }

    @Override
    public List<Var> getVars() {
        return this.getSelectHandler().getVars();
    }

    @Override
    public SelectBuilder fromNamed(String graphName) {
        this.getDatasetHandler().fromNamed(graphName);
        return this;
    }

    @Override
    public SelectBuilder fromNamed(Collection<String> graphNames) {
        this.getDatasetHandler().fromNamed(graphNames);
        return this;
    }

    @Override
    public SelectBuilder from(String graphName) {
        this.getDatasetHandler().from(graphName);
        return this;
    }

    @Override
    public SelectBuilder from(Collection<String> graphName) {
        this.getDatasetHandler().from(graphName);
        return this;
    }

    @Override
    public SelectBuilder addOrderBy(Expr orderBy) {
        this.getSolutionModifierHandler().addOrderBy(orderBy);
        return this;
    }

    @Override
    public SelectBuilder addOrderBy(Object orderBy) {
        this.getSolutionModifierHandler().addOrderBy(Converters.makeVar(orderBy));
        return this;
    }

    @Override
    public SelectBuilder addOrderBy(SortCondition orderBy) {
        this.getSolutionModifierHandler().addOrderBy(orderBy);
        return this;
    }

    @Override
    public SelectBuilder addOrderBy(Expr orderBy, Order order) {
        this.getSolutionModifierHandler().addOrderBy(orderBy, order);
        return this;
    }

    @Override
    public SelectBuilder addOrderBy(Object orderBy, Order order) {
        this.getSolutionModifierHandler().addOrderBy(Converters.makeVar(orderBy), order);
        return this;
    }

    @Override
    public SelectBuilder addGroupBy(Object groupBy) {
        this.getSolutionModifierHandler().addGroupBy(Converters.makeVar(groupBy));
        return this;
    }

    @Override
    public SelectBuilder addGroupBy(Expr groupBy) {
        this.getSolutionModifierHandler().addGroupBy(groupBy);
        return this;
    }

    @Override
    public SelectBuilder addGroupBy(Object var, Expr expr) {
        this.getSolutionModifierHandler().addGroupBy(Converters.makeVar(var), expr);
        return this;
    }

    @Override
    public SelectBuilder addGroupBy(Object var, String expr) {
        this.getSolutionModifierHandler().addGroupBy(Converters.makeVar(var), this.makeExpr(expr));
        return this;
    }

    @Override
    public SolutionModifierHandler getSolutionModifierHandler() {
        return this.handlerBlock.getModifierHandler();
    }

    @Override
    public SelectBuilder addHaving(String having) {
        this.getSolutionModifierHandler().addHaving(having);
        return this;
    }

    @Override
    public SelectBuilder addHaving(Expr expression) {
        this.getSolutionModifierHandler().addHaving(expression);
        return this;
    }

    @Override
    public SelectBuilder addHaving(Object var) {
        this.getSolutionModifierHandler().addHaving(Converters.makeVar(var));
        return this;
    }

    @Override
    public SelectBuilder setLimit(int limit) {
        this.getSolutionModifierHandler().setLimit(limit);
        return this;
    }

    @Override
    public SelectBuilder setOffset(int offset) {
        this.getSolutionModifierHandler().setOffset(offset);
        return this;
    }

    private static String toString(Node node) {
        if (node.isBlank()) {
            return node.getBlankNodeLabel();
        }
        if (node.isLiteral()) {
            return node.toString();
        }
        if (node.isURI()) {
            return String.format("<%s>", node.getURI());
        }
        if (node.isVariable()) {
            return String.format("?%s", node.getName());
        }
        return node.toString();
    }

    public static String makeString(Object o) {
        if (o instanceof FrontsNode) {
            return SelectBuilder.toString(((FrontsNode)o).asNode());
        }
        if (o instanceof Node) {
            return SelectBuilder.toString((Node)o);
        }
        return o.toString();
    }

    @Override
    public SelectBuilder addWhere(TriplePath t) {
        this.getWhereHandler().addWhere(t);
        return this;
    }

    @Override
    public SelectBuilder addWhere(Collection<TriplePath> collection) {
        this.getWhereHandler().addWhere(collection);
        return this;
    }

    @Override
    public SelectBuilder addWhere(Triple t) {
        this.getWhereHandler().addWhere(new TriplePath(t));
        return this;
    }

    @Override
    public SelectBuilder addWhere(FrontsTriple t) {
        this.getWhereHandler().addWhere(new TriplePath(t.asTriple()));
        return this;
    }

    @Override
    public SelectBuilder addWhere(Object s, Object p, Object o) {
        this.getWhereHandler().addWhere(this.makeTriplePaths(s, p, o));
        return this;
    }

    @Override
    public SelectBuilder addWhereValueVar(Object var) {
        this.getWhereHandler().addValueVar(this.getPrologHandler().getPrefixes(), var);
        return this;
    }

    @Override
    public SelectBuilder addWhereValueVar(Object var, Object ... values) {
        this.getWhereHandler().addValueVar(this.getPrologHandler().getPrefixes(), var, values);
        return this;
    }

    @Override
    public <K extends Collection<?>> SelectBuilder addWhereValueVars(Map<?, K> dataTable) {
        this.getWhereHandler().addValueVars(this.getPrologHandler().getPrefixes(), dataTable);
        return this;
    }

    @Override
    public SelectBuilder addWhereValueRow(Object ... values) {
        this.getWhereHandler().addValueRow(this.getPrologHandler().getPrefixes(), values);
        return this;
    }

    @Override
    public SelectBuilder addWhereValueRow(Collection<?> values) {
        this.getWhereHandler().addValueRow(this.getPrologHandler().getPrefixes(), values);
        return this;
    }

    @Override
    public List<Var> getWhereValuesVars() {
        return this.getWhereHandler().getValuesVars();
    }

    @Override
    public Map<Var, List<Node>> getWhereValuesMap() {
        return this.getWhereHandler().getValuesMap();
    }

    @Override
    public SelectBuilder clearWhereValues() {
        this.getWhereHandler().clearValues();
        return this;
    }

    @Override
    public SelectBuilder addOptional(TriplePath t) {
        this.getWhereHandler().addOptional(Arrays.asList(t));
        return this;
    }

    @Override
    public SelectBuilder addOptional(Triple t) {
        return this.addOptional(new TriplePath(t));
    }

    @Override
    public SelectBuilder addOptional(FrontsTriple t) {
        return this.addOptional(new TriplePath(t.asTriple()));
    }

    @Override
    public SelectBuilder addOptional(Collection<TriplePath> collection) {
        this.getWhereHandler().addOptional(collection);
        return this;
    }

    @Override
    public SelectBuilder addOptional(Object s, Object p, Object o) {
        this.getWhereHandler().addOptional(this.makeTriplePaths(s, p, o));
        return this;
    }

    @Override
    public SelectBuilder addOptional(AbstractQueryBuilder<?> t) {
        this.getWhereHandler().addOptional(t.getWhereHandler());
        return this;
    }

    @Override
    public SelectBuilder addFilter(Expr expr) {
        this.getWhereHandler().addFilter(expr);
        return this;
    }

    @Override
    public SelectBuilder addFilter(String s) {
        this.getWhereHandler().addFilter(s);
        return this;
    }

    @Override
    public SelectBuilder addSubQuery(AbstractQueryBuilder<?> subQuery) {
        this.getWhereHandler().addSubQuery(subQuery);
        return this;
    }

    @Override
    public SelectBuilder addUnion(AbstractQueryBuilder<?> subQuery) {
        this.getWhereHandler().addUnion(subQuery);
        return this;
    }

    @Override
    public SelectBuilder addGraph(Object graph, AbstractQueryBuilder<?> subQuery) {
        this.getPrologHandler().addAll(subQuery.getPrologHandler());
        this.getWhereHandler().addGraph(this.makeNode(graph), subQuery.getWhereHandler());
        return this;
    }

    @Override
    public SelectBuilder addGraph(Object graph, FrontsTriple triple) {
        return this.addGraph(graph, new TriplePath(triple.asTriple()));
    }

    @Override
    public SelectBuilder addGraph(Object graph, Object subject, Object predicate, Object object) {
        this.getWhereHandler().addGraph(this.makeNode(graph), this.makeTriplePaths(subject, predicate, object));
        return this;
    }

    @Override
    public SelectBuilder addGraph(Object graph, Triple triple) {
        return this.addGraph(graph, new TriplePath(triple));
    }

    @Override
    public SelectBuilder addGraph(Object graph, TriplePath triplePath) {
        this.getWhereHandler().addGraph(this.makeNode(graph), Arrays.asList(triplePath));
        return this;
    }

    @Override
    public SelectBuilder addGraph(Object graph, Collection<TriplePath> collection) {
        this.getWhereHandler().addGraph(this.makeNode(graph), collection);
        return this;
    }

    @Override
    public SelectBuilder addBind(Expr expression, Object var) {
        this.getWhereHandler().addBind(expression, Converters.makeVar(var));
        return this;
    }

    @Override
    public SelectBuilder addBind(String expression, Object var) {
        this.getWhereHandler().addBind(expression, Converters.makeVar(var));
        return this;
    }

    @Override
    public SelectHandler getSelectHandler() {
        return this.handlerBlock.getSelectHandler();
    }

    @Override
    @Deprecated(since="5.0.0")
    public Node list(Object ... objs) {
        return this.getWhereHandler().list(objs);
    }

    @Override
    public SelectBuilder addMinus(AbstractQueryBuilder<?> t) {
        this.getWhereHandler().addMinus(t);
        return this;
    }
}

