/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder.handlers;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.jena.arq.querybuilder.handlers.Handler;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.Var;

public class DatasetHandler
implements Handler {
    private final Query query;

    public DatasetHandler(Query query) {
        this.query = query;
    }

    public void addAll(DatasetHandler datasetHandler) {
        this.from(datasetHandler.query.getGraphURIs());
        this.fromNamed(datasetHandler.query.getNamedGraphURIs());
    }

    public void fromNamed(String graphName) {
        this.query.addNamedGraphURI(graphName);
    }

    public void fromNamed(Collection<String> graphNames) {
        for (String uri : graphNames) {
            this.query.addNamedGraphURI(uri);
        }
    }

    public void from(String graphName) {
        this.query.addGraphURI(graphName);
    }

    public void from(Collection<String> graphNames) {
        for (String uri : graphNames) {
            this.query.addGraphURI(uri);
        }
    }

    private void setVars(Map<Var, Node> values, List<String> lst) {
        if (values.isEmpty() || lst == null || lst.isEmpty()) {
            return;
        }
        for (int i = 0; i < lst.size(); ++i) {
            String s = lst.get(i);
            Node n = null;
            if (!s.startsWith("?")) continue;
            Var v = Var.alloc((String)s.substring(1));
            n = values.get(v);
            String x = s;
            if (n != null) {
                x = n.isURI() ? n.getURI() : (n.isLiteral() ? n.getLiteralLexicalForm() : n.toString());
            }
            lst.set(i, x);
        }
    }

    @Override
    public void setVars(Map<Var, Node> values) {
        this.setVars(values, this.query.getNamedGraphURIs());
        this.setVars(values, this.query.getGraphURIs());
    }

    @Override
    public void build() {
    }
}

