/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder.updatebuilder;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.jena.arq.querybuilder.AbstractQueryBuilder;
import org.apache.jena.arq.querybuilder.Converters;
import org.apache.jena.arq.querybuilder.clauses.SelectClause;
import org.apache.jena.arq.querybuilder.handlers.WhereHandler;
import org.apache.jena.arq.querybuilder.rewriters.BuildElementVisitor;
import org.apache.jena.arq.querybuilder.rewriters.ElementRewriter;
import org.apache.jena.arq.querybuilder.updatebuilder.PrefixHandler;
import org.apache.jena.arq.querybuilder.updatebuilder.QuadHolder;
import org.apache.jena.arq.querybuilder.updatebuilder.QuadIteratorBuilder;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementMinus;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementOptional;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.ElementUnion;
import org.apache.jena.sparql.syntax.ElementVisitor;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NiceIterator;
import org.apache.jena.vocabulary.RDF;

public class WhereQuadHolder
implements QuadHolder {
    private Element whereClause;
    private final PrefixHandler prefixHandler;
    private static Predicate<Node> checkPredicate = n -> n.isURI() || n.isVariable() || n.equals((Object)Node.ANY);
    private static Predicate<Node> checkSubject = n -> checkPredicate.test((Node)n) || n.isBlank() || n.isNodeTriple();

    public WhereQuadHolder(PrefixHandler prefixHandler) {
        this.prefixHandler = prefixHandler;
    }

    public boolean isEmpty() {
        return this.whereClause == null || this.whereClause instanceof ElementGroup && ((ElementGroup)this.whereClause).isEmpty();
    }

    @Override
    public ExtendedIterator<Quad> getQuads() {
        return this.getQuads(Quad.defaultGraphNodeGenerated);
    }

    public ExtendedIterator<Quad> getQuads(Node defaultGraphName) {
        if (this.isEmpty()) {
            return NiceIterator.emptyIterator();
        }
        QuadIteratorBuilder builder = new QuadIteratorBuilder(defaultGraphName);
        this.whereClause.visit((ElementVisitor)builder);
        return builder.iter;
    }

    public void addAll(WhereHandler whereHandler) {
        Element e = whereHandler.getQueryPattern();
        if (e != null) {
            ElementRewriter rewriter = new ElementRewriter(Collections.emptyMap());
            e.visit((ElementVisitor)rewriter);
            Element clone = (Element)rewriter.getResult();
            if (this.whereClause == null) {
                this.whereClause = clone;
            } else {
                ElementGroup eg = null;
                if (this.whereClause instanceof ElementGroup) {
                    eg = (ElementGroup)this.whereClause;
                } else {
                    eg = new ElementGroup();
                    eg.addElement(this.whereClause);
                }
                if (clone instanceof ElementGroup) {
                    for (Element ele : ((ElementGroup)clone).getElements()) {
                        eg.addElement(ele);
                    }
                } else {
                    eg.addElement(clone);
                }
                this.whereClause = eg;
            }
        }
    }

    public ElementGroup getClause() {
        Element e = this.whereClause;
        if (e == null) {
            this.whereClause = e = new ElementGroup();
        }
        if (e instanceof ElementGroup) {
            return (ElementGroup)e;
        }
        ElementGroup eg = new ElementGroup();
        eg.addElement(e);
        this.whereClause = eg;
        return eg;
    }

    private static void testTriple(TriplePath t) {
        boolean validObject;
        boolean validSubject = checkSubject.test(t.getSubject());
        boolean validPredicate = t.isTriple() ? checkPredicate.test(t.getPredicate()) : t.getPath() != null;
        boolean bl = validObject = checkSubject.test(t.getObject()) || t.getObject().isLiteral();
        if (!(validSubject && validPredicate && validObject)) {
            StringBuilder sb = new StringBuilder();
            if (!validSubject) {
                sb.append(String.format("Subject (%s) must be a URI, blank, variable, or a wildcard. %n", t.getSubject()));
            }
            if (!validPredicate) {
                sb.append(String.format("Predicate (%s) must be a Path, URI , variable, or a wildcard. %n", t.getPredicate()));
            }
            if (!validObject) {
                sb.append(String.format("Object (%s) must be a URI, literal, blank, , variable, or a wildcard. %n", t.getObject()));
            }
            if (!validSubject || !validPredicate) {
                sb.append(String.format("Is a prefix missing?  Prefix must be defined before use. %n", new Object[0]));
            }
            throw new IllegalArgumentException(sb.toString());
        }
    }

    public void addWhere(TriplePath t) throws IllegalArgumentException {
        WhereQuadHolder.testTriple(t);
        ElementGroup eg = this.getClause();
        List lst = eg.getElements();
        if (lst.isEmpty()) {
            ElementPathBlock epb = new ElementPathBlock();
            epb.addTriple(t);
            eg.addElement((Element)epb);
        } else {
            Element e = (Element)lst.get(lst.size() - 1);
            if (e instanceof ElementTriplesBlock && t.isTriple()) {
                ElementTriplesBlock etb = (ElementTriplesBlock)e;
                etb.addTriple(t.asTriple());
            } else if (e instanceof ElementPathBlock) {
                ElementPathBlock epb = (ElementPathBlock)e;
                epb.addTriple(t);
            } else {
                ElementPathBlock etb = new ElementPathBlock();
                etb.addTriple(t);
                eg.addElement((Element)etb);
            }
        }
    }

    public void addWhere(Collection<TriplePath> t) throws IllegalArgumentException {
        t.forEach(this::addWhere);
    }

    public void addOptional(TriplePath t) throws IllegalArgumentException {
        WhereQuadHolder.testTriple(t);
        ElementPathBlock epb = new ElementPathBlock();
        epb.addTriple(t);
        ElementOptional opt = new ElementOptional((Element)epb);
        this.getClause().addElement((Element)opt);
    }

    public void addOptional(Collection<TriplePath> t) throws IllegalArgumentException {
        ElementPathBlock epb = new ElementPathBlock();
        t.forEach(tp -> {
            WhereQuadHolder.testTriple(tp);
            epb.addTriple(tp);
        });
        ElementOptional opt = new ElementOptional((Element)epb);
        this.getClause().addElement((Element)opt);
    }

    public void addOptional(WhereHandler whereHandler) {
        this.getClause().addElement((Element)new ElementOptional((Element)whereHandler.getClause()));
    }

    public void addFilter(String expression) {
        this.getClause().addElement((Element)new ElementFilter(this.parseExpr(expression)));
    }

    private Expr parseExpr(String expression) {
        Query query = new Query();
        query.setPrefixMapping(this.prefixHandler.getPrefixes());
        return ExprUtils.parse((Query)query, (String)expression, (boolean)true);
    }

    public void addFilter(Expr expr) {
        this.getClause().addElement((Element)new ElementFilter(expr));
    }

    public void addSubQuery(AbstractQueryBuilder<?> subQuery) {
        this.getClause().addElement((Element)subQuery.asSubQuery());
    }

    public void addUnion(AbstractQueryBuilder<?> subQuery) {
        ElementUnion union = null;
        ElementGroup clause = this.getClause();
        if (!clause.isEmpty()) {
            Element lastElement = (Element)clause.getElements().get(clause.getElements().size() - 1);
            if (lastElement instanceof ElementUnion) {
                union = (ElementUnion)lastElement;
            } else {
                union = new ElementUnion();
                union.addElement((Element)clause);
                this.whereClause = union;
            }
        } else {
            union = new ElementUnion();
            clause.addElement((Element)union);
        }
        if (subQuery instanceof SelectClause && ((SelectClause)((Object)subQuery)).getVars().size() > 0) {
            union.addElement((Element)subQuery.asSubQuery());
        } else {
            this.prefixHandler.addPrefixes(subQuery.getPrologHandler().getPrefixes());
            union.addElement((Element)subQuery.getWhereHandler().getClause());
        }
    }

    public void addGraph(Node graph, WhereHandler subQuery) {
        this.getClause().addElement((Element)new ElementNamedGraph(graph, (Element)subQuery.getClause()));
    }

    public void addBind(Expr expr, Var var) {
        this.getClause().addElement((Element)new ElementBind(var, expr));
    }

    public void addBind(String expression, Var var) {
        this.getClause().addElement((Element)new ElementBind(var, this.parseExpr(expression)));
    }

    public WhereQuadHolder setVars(Map<Var, Node> values) {
        if (this.whereClause != null) {
            ElementRewriter r = new ElementRewriter(values);
            this.whereClause.visit((ElementVisitor)r);
            this.whereClause = (Element)r.getResult();
        }
        return this;
    }

    @Override
    public QuadHolder setValues(Map<Var, Node> values) {
        this.setVars(values);
        return this;
    }

    @Deprecated(since="5.0.0")
    public Node list(Object ... objs) {
        Node retval;
        Node lastObject = retval = NodeFactory.createBlankNode();
        for (int i = 0; i < objs.length; ++i) {
            Node n = Converters.makeNode(objs[i], this.prefixHandler.getPrefixes());
            this.addWhere(new TriplePath(Triple.create((Node)lastObject, (Node)RDF.first.asNode(), (Node)n)));
            if (i + 1 < objs.length) {
                Node nextObject = NodeFactory.createBlankNode();
                this.addWhere(new TriplePath(Triple.create((Node)lastObject, (Node)RDF.rest.asNode(), (Node)nextObject)));
                lastObject = nextObject;
                continue;
            }
            this.addWhere(new TriplePath(Triple.create((Node)lastObject, (Node)RDF.rest.asNode(), (Node)RDF.nil.asNode())));
        }
        return retval;
    }

    public void addMinus(AbstractQueryBuilder<?> qb) {
        this.prefixHandler.addPrefixes(qb.getPrologHandler().getPrefixes());
        ElementGroup clause = this.getClause();
        ElementMinus minus = new ElementMinus((Element)qb.getWhereHandler().getClause());
        clause.addElement((Element)minus);
    }

    public Element build() {
        BuildElementVisitor visitor = new BuildElementVisitor();
        this.whereClause.visit((ElementVisitor)visitor);
        return this.whereClause;
    }
}

