/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder.updatebuilder;

import java.util.Iterator;
import java.util.function.Function;
import org.apache.jena.arq.querybuilder.Converters;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementAssign;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementData;
import org.apache.jena.sparql.syntax.ElementDataset;
import org.apache.jena.sparql.syntax.ElementExists;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementLateral;
import org.apache.jena.sparql.syntax.ElementMinus;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementNotExists;
import org.apache.jena.sparql.syntax.ElementOptional;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementService;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.ElementUnfold;
import org.apache.jena.sparql.syntax.ElementUnion;
import org.apache.jena.sparql.syntax.ElementVisitor;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

class QuadIteratorBuilder
implements ElementVisitor {
    private final Node defaultGraph;
    ExtendedIterator<Quad> iter = WrappedIterator.emptyIterator();
    private final Function<Triple, Quad> MAP = new Function<Triple, Quad>(){

        @Override
        public Quad apply(Triple triple) {
            return new Quad(QuadIteratorBuilder.this.defaultGraph, Converters.checkVar(triple.getSubject()), Converters.checkVar(triple.getPredicate()), Converters.checkVar(triple.getObject()));
        }
    };

    QuadIteratorBuilder(Node defaultGraph) {
        this.defaultGraph = defaultGraph;
    }

    public void visit(ElementTriplesBlock el) {
        this.iter = this.iter.andThen((Iterator)WrappedIterator.create(el.getPattern().getList().iterator()).mapWith(this.MAP));
    }

    public void visit(ElementPathBlock el) {
        for (TriplePath pth2 : el.getPattern().getList()) {
            if (pth2.isTriple()) continue;
            throw new QueryParseException("Paths not permitted in data quad", -1, -1);
        }
        this.iter = this.iter.andThen((Iterator)WrappedIterator.create(el.getPattern().getList().iterator()).mapWith(pth -> pth.asTriple()).mapWith(this.MAP));
    }

    public void visit(ElementFilter el) {
        throw new QueryParseException("Paths not permitted in data quad", -1, -1);
    }

    public void visit(ElementAssign el) {
        throw new QueryParseException("element assignment not permitted in data quad", -1, -1);
    }

    public void visit(ElementBind el) {
        throw new QueryParseException("bind not permitted in data quad", -1, -1);
    }

    public void visit(ElementUnfold el) {
        throw new QueryParseException("unfold not permitted in data quad", -1, -1);
    }

    public void visit(ElementData el) {
        throw new QueryParseException("element data not permitted in data quad", -1, -1);
    }

    public void visit(ElementUnion el) {
        for (Element e : el.getElements()) {
            e.visit((ElementVisitor)this);
        }
    }

    public void visit(ElementLateral el) {
        throw new QueryParseException("lateral not permitted in data quad", -1, -1);
    }

    public void visit(ElementOptional el) {
        throw new QueryParseException("optional not permitted in data quad", -1, -1);
    }

    public void visit(ElementGroup el) {
        for (Element e : el.getElements()) {
            e.visit((ElementVisitor)this);
        }
    }

    public void visit(ElementDataset el) {
        this.iter = this.iter.andThen(el.getDataset().find());
    }

    public void visit(ElementNamedGraph el) {
        QuadIteratorBuilder bldr = new QuadIteratorBuilder(el.getGraphNameNode());
        el.getElement().visit((ElementVisitor)bldr);
        this.iter = this.iter.andThen(bldr.iter);
    }

    public void visit(ElementExists el) {
        throw new QueryParseException("exists not permitted in data quad", -1, -1);
    }

    public void visit(ElementNotExists el) {
        throw new QueryParseException("not exists not permitted in data quad", -1, -1);
    }

    public void visit(ElementMinus el) {
        throw new QueryParseException("minus not permitted in data quad", -1, -1);
    }

    public void visit(ElementService el) {
        throw new QueryParseException("service not permitted in data quad", -1, -1);
    }

    public void visit(ElementSubQuery el) {
        Query q = el.getQuery();
        q.getQueryPattern().visit((ElementVisitor)this);
    }
}

