/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfconnection;

import org.apache.http.client.HttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.jena.rdfconnection.RDFConnectionRemote;
import org.apache.jena.rdfconnection.RDFConnectionRemoteBuilder;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.sparql.core.Transactional;

public class RDFConnectionFuseki
extends RDFConnectionRemote {
    public static RDFConnectionRemoteBuilder create() {
        return RDFConnectionFuseki.setupForFuseki(RDFConnectionRemote.create());
    }

    public static RDFConnectionRemoteBuilder create(RDFConnectionFuseki other) {
        return RDFConnectionFuseki.setupCreator(RDFConnectionRemote.create(other));
    }

    private static RDFConnectionRemoteBuilder setupForFuseki(RDFConnectionRemoteBuilder builder) {
        String ctRDFThrift = Lang.RDFTHRIFT.getContentType().getContentType();
        String acceptHeaderSPARQL = String.join((CharSequence)",", ResultSetLang.SPARQLResultSetThrift.getHeaderString(), ResultSetLang.SPARQLResultSetJSON.getHeaderString() + ";q=0.9", Lang.RDFTHRIFT.getHeaderString());
        return builder.quadsFormat(RDFFormat.RDF_THRIFT).triplesFormat(RDFFormat.RDF_THRIFT).acceptHeaderGraph(ctRDFThrift).acceptHeaderDataset(ctRDFThrift).acceptHeaderSelectQuery(ResultSetLang.SPARQLResultSetThrift.getHeaderString()).acceptHeaderAskQuery(ResultSetLang.SPARQLResultSetJSON.getHeaderString()).acceptHeaderQuery(acceptHeaderSPARQL).parseCheckSPARQL(false).creator(b -> RDFConnectionFuseki.fusekiMaker(b));
    }

    private static RDFConnectionRemoteBuilder setupCreator(RDFConnectionRemoteBuilder builder) {
        return builder.creator(b -> RDFConnectionFuseki.fusekiMaker(b));
    }

    static RDFConnectionFuseki fusekiMaker(RDFConnectionRemoteBuilder builder) {
        return new RDFConnectionFuseki(builder);
    }

    protected RDFConnectionFuseki(RDFConnectionRemoteBuilder base) {
        this(base.txnLifecycle, base.httpClient, base.httpContext, base.destination, base.queryURL, base.updateURL, base.gspURL, base.outputQuads, base.outputTriples, base.acceptDataset, base.acceptGraph, base.acceptSparqlResults, base.acceptSelectResult, base.acceptAskResult, base.parseCheckQueries, base.parseCheckUpdates);
    }

    protected RDFConnectionFuseki(Transactional txnLifecycle, HttpClient httpClient, HttpContext httpContext, String destination, String queryURL, String updateURL, String gspURL, RDFFormat outputQuads, RDFFormat outputTriples, String acceptDataset, String acceptGraph, String acceptSparqlResults, String acceptSelectResult, String acceptAskResult, boolean parseCheckQueries, boolean parseCheckUpdates) {
        super(txnLifecycle, httpClient, httpContext, destination, queryURL, updateURL, gspURL, outputQuads, outputTriples, acceptDataset, acceptGraph, acceptSparqlResults, acceptSelectResult, acceptAskResult, parseCheckQueries, parseCheckUpdates);
    }
}

