/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb;

import org.apache.jena.query.ARQ;
import org.apache.jena.sdb.assembler.AssemblerVocab;
import org.apache.jena.sdb.core.SDBConstants;
import org.apache.jena.sdb.engine.QueryEngineSDB;
import org.apache.jena.sdb.modify.UpdateEngineSDB;
import org.apache.jena.sdb.util.DerbyUtils;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.lib.Metadata;
import org.apache.jena.sparql.mgt.SystemInfo;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.MappingRegistry;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.system.JenaSystem;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class SDB {
    private static volatile boolean initialized = false;
    private static Object initLock = new Object();
    public static final String sdbIRI = "http://jena.hpl.hp.com/#sdb";
    public static final String namespace = "http://jena.hpl.hp.com/2007/sdb#";
    public static final String symbolPrefix = "sdb";
    public static final String symbolSpace = "http://jena.hpl.hp.com/SDB/symbol#";
    public static final Symbol useQuadRewrite = SDBConstants.allocSymbol("useQuadRewrite");
    public static final Symbol unionDefaultGraph = SDBConstants.allocSymbol("unionDefaultGraph");
    public static final Symbol streamGraphAPI = SDBConstants.allocSymbol("streamGraphAPI");
    public static final Symbol jdbcStream = SDBConstants.allocSymbol("jdbcStream");
    public static final Symbol jdbcFetchSize = SDBConstants.allocSymbol("jdbcFetchSize");
    public static final Symbol annotateGeneratedSQL = SDBConstants.allocSymbol("annotateGeneratedSQL");
    private static final String rdfPrefix;
    private static final String rdfsPrefix;
    private static final String owlPrefix;
    private static final String xsdPrefix = "http://www.w3.org/2001/XMLSchema#";
    protected static PrefixMapping globalPrefixMap;
    private static String metadataLocation;
    private static Metadata metadata;
    public static final String PATH = "org.apache.jena.sdb";
    public static final String NAME = "SDB";
    public static final String VERSION;
    public static final String BUILD_DATE;

    public static Context getContext() {
        return ARQ.getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        if (initialized) {
            return;
        }
        Object object = initLock;
        synchronized (object) {
            if (initialized) {
                JenaSystem.logLifecycle((String)"SDB.init - skip", (Object[])new Object[0]);
                return;
            }
            initialized = true;
            JenaSystem.logLifecycle((String)"SDB.init - start", (Object[])new Object[0]);
            MappingRegistry.addPrefixMapping((String)symbolPrefix, (String)symbolSpace);
            DerbyUtils.setDerbyPageCacheSize(10000);
            QueryEngineSDB.register();
            UpdateEngineSDB.register();
            SDB.getContext().setIfUndef(useQuadRewrite, (Object)false);
            SDB.getContext().setIfUndef(streamGraphAPI, (Object)false);
            SDB.getContext().setIfUndef(jdbcStream, (Object)true);
            SDB.getContext().setIfUndef(annotateGeneratedSQL, (Object)true);
            AssemblerVocab.init();
            JenaSystem.logLifecycle((String)"SDB.init - finish", (Object[])new Object[0]);
        }
    }

    public static PrefixMapping getGlobalPrefixMapping() {
        return globalPrefixMap;
    }

    public static Symbol allocSymbol(String shortName) {
        if (shortName.startsWith("http://jena.apache.org/ARQ#")) {
            throw new ARQInternalErrorException("Symbol short name begins with the ARQ namespace name: " + shortName);
        }
        return Symbol.create((String)("http://jena.apache.org/ARQ#" + shortName));
    }

    private static void initlization2() {
        SystemInfo systemInfo = new SystemInfo(sdbIRI, PATH, VERSION, BUILD_DATE);
        SystemARQ.registerSubSystem((SystemInfo)systemInfo);
    }

    static {
        JenaSystem.init();
        rdfPrefix = RDF.getURI();
        rdfsPrefix = RDFS.getURI();
        owlPrefix = OWL.getURI();
        globalPrefixMap = new PrefixMappingImpl();
        globalPrefixMap.setNsPrefix("rdf", rdfPrefix);
        globalPrefixMap.setNsPrefix("rdfs", rdfsPrefix);
        globalPrefixMap.setNsPrefix("xsd", xsdPrefix);
        globalPrefixMap.setNsPrefix("owl", owlPrefix);
        globalPrefixMap.setNsPrefix(symbolPrefix, namespace);
        metadataLocation = "org/apache/jena/sdb/sdb-properties.xml";
        metadata = new Metadata(metadataLocation);
        VERSION = metadata.get("org.apache.jena.sdb.version", "unknown");
        BUILD_DATE = metadata.get("org.apache.jena.sdb.build.datetime", "unset");
        SDB.initlization2();
    }
}

