/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.compiler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.sdb.compiler.QuadBlock;
import org.apache.jena.sdb.compiler.SlotCompiler;
import org.apache.jena.sdb.compiler.SqlBuilder;
import org.apache.jena.sdb.compiler.SqlStage;
import org.apache.jena.sdb.core.SDBRequest;
import org.apache.jena.sdb.core.sqlexpr.SqlColumn;
import org.apache.jena.sdb.core.sqlexpr.SqlExprList;
import org.apache.jena.sdb.core.sqlnode.SqlNode;
import org.apache.jena.sdb.core.sqlnode.SqlTable;
import org.apache.jena.sdb.store.TableDesc;
import org.apache.jena.sparql.core.Quad;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternTable
extends TableDesc {
    private static Logger log = LoggerFactory.getLogger(PatternTable.class);
    static final String subjColName = "subject";
    Map<Node, String> cols = new HashMap<Node, String>();

    public PatternTable(String tableName) {
        super(tableName);
    }

    public void add(Node property, String colname) {
        this.cols.put(property, colname);
    }

    public Map<Node, String> getCols() {
        return this.cols;
    }

    @Override
    public boolean hasColumn(String colName) {
        return this.cols.containsKey(colName);
    }

    @Override
    public Iterator<String> colNames() {
        return this.cols.values().iterator();
    }

    public boolean trigger(Quad quad) {
        for (Node p : this.cols.keySet()) {
            if (!p.equals((Object)quad.getPredicate())) continue;
            return true;
        }
        return false;
    }

    public SqlStage process(int i, QuadBlock quadBlock) {
        QuadBlock tableQuads = new QuadBlock();
        HashSet<Node> predicates = new HashSet<Node>(this.cols.keySet());
        Quad trigger = (Quad)quadBlock.get(i);
        Node subject = trigger.getSubject();
        Node graph = trigger.getGraph();
        for (Node p : predicates) {
            int idx = quadBlock.findFirst(i, graph, subject, p, null);
            if (idx < 0) continue;
            Quad q = (Quad)quadBlock.get(idx);
            tableQuads.add(q);
        }
        quadBlock.removeAll(tableQuads);
        SqlStagePatternTable stage = new SqlStagePatternTable(graph, subject, tableQuads);
        return stage;
    }

    class SqlStagePatternTable
    implements SqlStage {
        private QuadBlock tableQuads;
        private Node graphNode;
        private Node subject;

        public SqlStagePatternTable(Node graphNode, Node subject, QuadBlock tableQuads) {
            this.tableQuads = tableQuads;
            this.subject = subject;
            this.graphNode = graphNode;
        }

        @Override
        public SqlNode build(SDBRequest request, SlotCompiler slotCompiler) {
            SqlTable sqlTable = new SqlTable("ALIAS", "TABLE");
            SqlExprList conditions = new SqlExprList();
            if (!Quad.isDefaultGraphGenerated((Node)this.graphNode)) {
                log.error("Not the default graph in SqlStagePTable.build");
            }
            slotCompiler.processSlot(request, sqlTable, conditions, this.subject, PatternTable.subjColName);
            for (Quad quad : this.tableQuads) {
                String colName = PatternTable.this.cols.get(quad.getPredicate());
                SqlColumn col = new SqlColumn(sqlTable, colName);
                Node obj = quad.getObject();
                slotCompiler.processSlot(request, sqlTable, conditions, obj, colName);
            }
            return SqlBuilder.restrict(request, (SqlNode)sqlTable, conditions);
        }

        public String toString() {
            return "PTable";
        }

        public void output(IndentedWriter out) {
            out.print("PTable");
        }
    }
}

