/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.compiler;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.sdb.compiler.OpSQL;
import org.apache.jena.sdb.compiler.QueryCompiler;
import org.apache.jena.sdb.core.SDBRequest;
import org.apache.jena.sdb.shared.SDBInternalError;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterRepeatApply;

public class QueryIterOpSQL
extends QueryIterRepeatApply {
    private final OpSQL opSQL;
    private final SDBRequest request;

    public QueryIterOpSQL(OpSQL op, QueryIterator input, ExecutionContext context) {
        super(input, context);
        this.opSQL = op;
        SDBRequest req = op.getRequest();
        if (req == null) {
            this.request = null;
        } else {
            PrefixMapping pmap = req.getQuery() == null ? null : req.getQuery().getPrefixMapping();
            this.request = op.getRequest() == null ? null : new SDBRequest(op.getRequest().getStore(), pmap, context.getContext());
        }
    }

    protected QueryIterator nextStage(Binding binding) {
        OpSQL execSQL = this.opSQL;
        if (binding != null && !QueryIterOpSQL.isRoot(binding)) {
            Op op2;
            QueryCompiler qc = this.opSQL.getRequest().getStore().getQueryCompilerFactory().createQueryCompiler(this.request);
            Op op = qc.compile(op2 = Substitute.substitute((Op)this.opSQL.getOriginal(), (Binding)binding));
            if (op instanceof OpSQL) {
                execSQL = (OpSQL)op;
            } else {
                throw new SDBInternalError("Failed to recompile the OpSQL to an OpSQL");
            }
        }
        return execSQL.exec(binding, this.getExecContext());
    }

    private static boolean isRoot(Binding binding) {
        return !binding.vars().hasNext();
    }

    public void output(IndentedWriter out) {
        this.opSQL.output(out);
    }
}

