/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.core;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.jena.sdb.core.Scope;
import org.apache.jena.sdb.core.ScopeEntry;
import org.apache.jena.sdb.core.ScopeStatus;
import org.apache.jena.sparql.core.Var;

public class Scope2
implements Scope {
    Scope left;
    Scope right;

    public Scope2(Scope left, Scope right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public boolean hasColumnForVar(Var var) {
        if (this.left != null && this.left.hasColumnForVar(var)) {
            return true;
        }
        return this.right != null && this.right.hasColumnForVar(var);
    }

    @Override
    public Set<Var> getVars() {
        LinkedHashSet<Var> acc = new LinkedHashSet<Var>();
        if (this.left != null) {
            acc.addAll(this.left.getVars());
        }
        if (this.right != null) {
            acc.addAll(this.right.getVars());
        }
        return acc;
    }

    @Override
    public boolean isEmpty() {
        return this.left.isEmpty() && this.right.isEmpty();
    }

    @Override
    public Set<ScopeEntry> findScopes() {
        HashSet<ScopeEntry> x = new HashSet<ScopeEntry>();
        for (Var v : this.getVars()) {
            ScopeEntry e = this.findScopeForVar(v);
            x.add(e);
        }
        return x;
    }

    @Override
    public ScopeEntry findScopeForVar(Var var) {
        ScopeEntry c1 = null;
        if (this.left != null) {
            c1 = this.left.findScopeForVar(var);
        }
        if (c1 != null && c1.getStatus() == ScopeStatus.FIXED) {
            return c1;
        }
        ScopeEntry c2 = null;
        if (this.right != null) {
            c2 = this.right.findScopeForVar(var);
        }
        if (c2 != null && c2.getStatus() == ScopeStatus.FIXED) {
            return c2;
        }
        if (c2 != null) {
            return c2;
        }
        if (c1 != null) {
            return c1;
        }
        return null;
    }

    public String toString() {
        String x = "";
        if (!this.left.isEmpty()) {
            x = this.left.toString();
        }
        if (!this.left.isEmpty() && !this.right.isEmpty()) {
            x = x + " ";
        }
        if (!this.right.isEmpty()) {
            x = x + this.right.toString();
        }
        return x;
    }
}

