/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.core.sqlexpr;

import org.apache.jena.sdb.core.sqlexpr.S_Like;
import org.apache.jena.sdb.core.sqlexpr.S_Regex;
import org.apache.jena.sdb.core.sqlexpr.SqlColumn;
import org.apache.jena.sdb.core.sqlexpr.SqlConstant;
import org.apache.jena.sdb.core.sqlexpr.SqlExpr;
import org.apache.jena.sdb.core.sqlexpr.SqlExpr1;
import org.apache.jena.sdb.core.sqlexpr.SqlExpr2;
import org.apache.jena.sdb.core.sqlexpr.SqlExprVisitor;
import org.apache.jena.sdb.core.sqlexpr.SqlFunction1;

public class SqlExprWalker {
    public static void walk(SqlExpr expr, SqlExprVisitor visitor) {
        expr.visit(new Walker(visitor));
    }

    private static class Walker
    implements SqlExprVisitor {
        private SqlExprVisitor visitor;

        private Walker(SqlExprVisitor visitor) {
            this.visitor = visitor;
        }

        @Override
        public void visit(SqlColumn column) {
            column.visit(this.visitor);
        }

        @Override
        public void visit(SqlConstant constant) {
            constant.visit(this.visitor);
        }

        @Override
        public void visit(SqlFunction1 expr) {
            expr.getExpr().visit(this);
            expr.visit(this.visitor);
        }

        @Override
        public void visit(SqlExpr1 expr) {
            expr.getExpr().visit(this);
            expr.visit(this.visitor);
        }

        @Override
        public void visit(SqlExpr2 expr) {
            expr.getLeft().visit(this);
            expr.getRight().visit(this);
            expr.visit(this.visitor);
        }

        @Override
        public void visit(S_Like like) {
            like.getExpr().visit(this);
            like.visit(this.visitor);
        }

        @Override
        public void visit(S_Regex regex) {
            regex.getExpr().visit(this);
            regex.visit(this.visitor);
        }
    }
}

