/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.core.sqlnode;

import org.apache.jena.sdb.core.sqlnode.SqlCoalesce;
import org.apache.jena.sdb.core.sqlnode.SqlDistinct;
import org.apache.jena.sdb.core.sqlnode.SqlJoinInner;
import org.apache.jena.sdb.core.sqlnode.SqlJoinLeftOuter;
import org.apache.jena.sdb.core.sqlnode.SqlNode;
import org.apache.jena.sdb.core.sqlnode.SqlNodeBase1;
import org.apache.jena.sdb.core.sqlnode.SqlNodeBase2;
import org.apache.jena.sdb.core.sqlnode.SqlNodeVisitor;
import org.apache.jena.sdb.core.sqlnode.SqlProject;
import org.apache.jena.sdb.core.sqlnode.SqlRename;
import org.apache.jena.sdb.core.sqlnode.SqlRestrict;
import org.apache.jena.sdb.core.sqlnode.SqlSelectBlock;
import org.apache.jena.sdb.core.sqlnode.SqlSlice;
import org.apache.jena.sdb.core.sqlnode.SqlTable;
import org.apache.jena.sdb.core.sqlnode.SqlUnion;

public class SqlNodeWalker {
    public SqlNodeVisitor visitor;

    public SqlNodeWalker(SqlNodeVisitor visitor) {
        this.visitor = visitor;
    }

    public static void walk(SqlNode node, SqlNodeVisitor visitor) {
        node.visit(new Walker(visitor));
    }

    static class Walker
    implements SqlNodeVisitor {
        public SqlNodeVisitor visitor;

        private Walker(SqlNodeVisitor visitor) {
            this.visitor = visitor;
        }

        private void visit1(SqlNodeBase1 sqlNode) {
            sqlNode.visit(this.visitor);
            sqlNode.getSubNode().visit(this);
        }

        private void visit2(SqlNodeBase2 sqlNode) {
            sqlNode.visit(this.visitor);
            sqlNode.getLeft().visit(this);
            sqlNode.getRight().visit(this);
        }

        public void visit(SqlProject sqlNode) {
            this.visit1(sqlNode);
        }

        public void visit(SqlDistinct sqlNode) {
            this.visit1(sqlNode);
        }

        public void visit(SqlRestrict sqlNode) {
            this.visit1(sqlNode);
        }

        public void visit(SqlRename sqlNode) {
            sqlNode.visit(this.visitor);
            sqlNode.getSubNode().visit(this);
        }

        @Override
        public void visit(SqlTable sqlNode) {
            sqlNode.visit(this.visitor);
        }

        @Override
        public void visit(SqlJoinInner sqlNode) {
            this.visit2(sqlNode);
        }

        @Override
        public void visit(SqlJoinLeftOuter sqlNode) {
            this.visit2(sqlNode);
        }

        @Override
        public void visit(SqlUnion sqlNode) {
            this.visit2(sqlNode);
        }

        @Override
        public void visit(SqlCoalesce sqlNode) {
            sqlNode.visit(this.visitor);
            sqlNode.getJoinNode().visit(this);
        }

        public void visit(SqlSlice sqlNode) {
            this.visit1(sqlNode);
        }

        @Override
        public void visit(SqlSelectBlock sqlNode) {
            this.visit1(sqlNode);
        }
    }
}

