/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.core.sqlnode;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.sdb.core.Generator;
import org.apache.jena.sdb.core.Scope;
import org.apache.jena.sdb.core.ScopeBase;
import org.apache.jena.sdb.core.ScopeEntry;
import org.apache.jena.sdb.core.sqlexpr.SqlColumn;
import org.apache.jena.sdb.core.sqlnode.ColAlias;
import org.apache.jena.sdb.core.sqlnode.SqlNode;
import org.apache.jena.sdb.core.sqlnode.SqlNodeBase1;
import org.apache.jena.sdb.core.sqlnode.SqlNodeVisitor;
import org.apache.jena.sdb.core.sqlnode.SqlTable;
import org.apache.jena.sdb.core.sqlnode.SqlTransform;
import org.apache.jena.sdb.shared.SDBInternalError;
import org.apache.jena.sparql.core.Var;

class SqlRename
extends SqlNodeBase1 {
    private ScopeBase idScope;
    private ScopeBase nodeScope;
    private SqlTable vTable;
    private List<ColAlias> columns;

    private static SqlNode view(String alias, SqlNode sqlNode) {
        return null;
    }

    private SqlRename(SqlTable here, SqlNode sqlNode) {
        super(here.getAliasName(), sqlNode);
        this.vTable = here;
        this.idScope = new ScopeBase();
        this.nodeScope = new ScopeBase();
        this.columns = new ArrayList<ColAlias>();
    }

    private SqlRename(SqlRename other) {
        super(other.vTable.getAliasName(), other.getSubNode());
        this.vTable = other.vTable;
        this.idScope = other.idScope;
        this.nodeScope = other.nodeScope;
        this.columns = new ArrayList<ColAlias>(other.columns);
    }

    private void merge(Scope scope, ScopeBase newScope, Generator gen) {
        String x = "";
        String sep = "";
        for (ScopeEntry e : scope.findScopes()) {
            SqlColumn oldCol = e.getColumn();
            Var v = e.getVar();
            String colName = gen.next();
            SqlColumn newCol = new SqlColumn(this.vTable, colName);
            this.columns.add(new ColAlias(oldCol, newCol));
            newScope.setColumnForVar(v, newCol);
            x = String.format("%s%s%s:(%s=>%s)", x, sep, v, oldCol, newCol);
            sep = " ";
        }
        if (x.length() > 0) {
            this.addNote(x);
        }
    }

    @Override
    public Scope getIdScope() {
        return this.idScope;
    }

    @Override
    public Scope getNodeScope() {
        return this.nodeScope;
    }

    @Override
    public void visit(SqlNodeVisitor visitor) {
        throw new SDBInternalError("SqlRename.visit");
    }

    @Override
    public SqlNode apply(SqlTransform transform, SqlNode subNode) {
        throw new SDBInternalError("SqlRename.apply");
    }

    @Override
    public SqlNode copy(SqlNode subNode) {
        return new SqlRename(this);
    }
}

