/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.core.sqlnode;

import org.apache.jena.sdb.core.sqlnode.SqlCoalesce;
import org.apache.jena.sdb.core.sqlnode.SqlDistinct;
import org.apache.jena.sdb.core.sqlnode.SqlJoinInner;
import org.apache.jena.sdb.core.sqlnode.SqlJoinLeftOuter;
import org.apache.jena.sdb.core.sqlnode.SqlNode;
import org.apache.jena.sdb.core.sqlnode.SqlNodeBase0;
import org.apache.jena.sdb.core.sqlnode.SqlNodeBase1;
import org.apache.jena.sdb.core.sqlnode.SqlNodeBase2;
import org.apache.jena.sdb.core.sqlnode.SqlProject;
import org.apache.jena.sdb.core.sqlnode.SqlRename;
import org.apache.jena.sdb.core.sqlnode.SqlRestrict;
import org.apache.jena.sdb.core.sqlnode.SqlSelectBlock;
import org.apache.jena.sdb.core.sqlnode.SqlSlice;
import org.apache.jena.sdb.core.sqlnode.SqlTable;
import org.apache.jena.sdb.core.sqlnode.SqlTransform;
import org.apache.jena.sdb.core.sqlnode.SqlUnion;

public class SqlTransformCopy
implements SqlTransform {
    public static final boolean COPY_ALWAYS = true;
    public static final boolean COPY_ONLY_ON_CHANGE = false;
    private boolean alwaysCopy = false;

    public SqlTransformCopy() {
        this(false);
    }

    public SqlTransformCopy(boolean alwaysDuplicate) {
        this.alwaysCopy = alwaysDuplicate;
    }

    @Override
    public SqlNode transform(SqlProject sqlProject, SqlNode subNode) {
        return this.xform(sqlProject, subNode);
    }

    public SqlNode transform(SqlDistinct sqlDistinct, SqlNode subNode) {
        return this.xform(sqlDistinct, subNode);
    }

    @Override
    public SqlNode transform(SqlRestrict sqlRestrict, SqlNode subNode) {
        return this.xform(sqlRestrict, subNode);
    }

    public SqlNode transform(SqlSlice sqlSlice, SqlNode subNode) {
        return this.xform(sqlSlice, subNode);
    }

    @Override
    public SqlNode transform(SqlSelectBlock sqlSelectBlock, SqlNode subNode) {
        return this.xform(sqlSelectBlock, subNode);
    }

    @Override
    public SqlNode transform(SqlJoinInner sqlJoinInner, SqlNode left, SqlNode right) {
        return this.xform(sqlJoinInner, left, right);
    }

    @Override
    public SqlNode transform(SqlJoinLeftOuter sqlJoinLeftOuter, SqlNode left, SqlNode right) {
        return this.xform(sqlJoinLeftOuter, left, right);
    }

    @Override
    public SqlNode transform(SqlUnion sqlUnion, SqlNode left, SqlNode right) {
        return this.xform(sqlUnion, left, right);
    }

    @Override
    public SqlNode transform(SqlTable sqlTable) {
        return this.xform(sqlTable);
    }

    @Override
    public SqlNode transform(SqlRename sqlRename, SqlNode subNode) {
        return this.xform(sqlRename, subNode);
    }

    @Override
    public SqlNode transform(SqlCoalesce sqlCoalesce, SqlNode subNode) {
        return this.xform(sqlCoalesce, subNode);
    }

    private SqlNode xform(SqlNodeBase0 sqlNode) {
        if (!this.alwaysCopy) {
            return sqlNode;
        }
        return sqlNode.copy();
    }

    private SqlNode xform(SqlNodeBase1 sqlNode, SqlNode subNode) {
        if (!this.alwaysCopy && sqlNode.getSubNode() == subNode) {
            return sqlNode;
        }
        return sqlNode.copy(subNode);
    }

    private SqlNode xform(SqlNodeBase2 sqlNode, SqlNode left, SqlNode right) {
        if (!this.alwaysCopy && sqlNode.getLeft() == left && sqlNode.getRight() == right) {
            return sqlNode;
        }
        return sqlNode.copy(left, right);
    }
}

