/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.layout1;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sdb.layout1.EncoderDecoder;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.FmtUtils;

public class CodecSimple
implements EncoderDecoder {
    private PrefixMapping prefixMapping;

    public CodecSimple() {
        this.prefixMapping = new PrefixMappingImpl();
    }

    public CodecSimple(PrefixMapping pMap) {
        this.prefixMapping = pMap;
    }

    @Override
    public String encode(Node node) {
        if (node.isBlank()) {
            return "_:" + node.getBlankNodeId().getLabelString();
        }
        String s = FmtUtils.stringForNode((Node)node, (PrefixMapping)this.prefixMapping);
        return s;
    }

    @Override
    public Node decode(String s) {
        if (s.startsWith("Double")) {
            System.err.println(s);
        }
        if (s.startsWith("_:")) {
            return NodeFactory.createBlankNode((String)s.substring(2));
        }
        return CodecSimple.stringToNode(s, this.prefixMapping);
    }

    static Node stringToNode(String string, PrefixMapping pmap) {
        return SSE.parseNode((String)string, (PrefixMapping)pmap);
    }
}

