/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.layout2.expr;

import org.apache.jena.sdb.compiler.ConditionCompiler;
import org.apache.jena.sdb.compiler.SDBConstraint;
import org.apache.jena.sdb.core.ExprPattern;
import org.apache.jena.sdb.exprmatch.ActionMatch;
import org.apache.jena.sdb.exprmatch.ActionMatchString;
import org.apache.jena.sdb.exprmatch.ActionMatchVar;
import org.apache.jena.sdb.exprmatch.MapResult;
import org.apache.jena.sdb.layout2.expr.RegexSqlGen;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;

public class RegexCompiler
implements ConditionCompiler {
    private static ExprPattern regex1 = new ExprPattern("regex(?a1, ?a2)", new Var[]{Var.alloc((String)"a1"), Var.alloc((String)"a2")}, new ActionMatch[]{new ActionMatchVar(), new ActionMatchString()});
    private static ExprPattern regex1_i = new ExprPattern("regex(?a1, ?a2, 'i')", new Var[]{Var.alloc((String)"a1"), Var.alloc((String)"a2")}, new ActionMatch[]{new ActionMatchVar(), new ActionMatchString()});

    @Override
    public SDBConstraint recognize(Expr expr) {
        MapResult rMap = null;
        rMap = regex1.match(expr);
        if (rMap != null) {
            Var var = rMap.get("a1").getExprVar().asVar();
            String pattern = rMap.get("a2").getConstant().getString();
            return new RegexSqlGen(expr, regex1, pattern, null, true);
        }
        rMap = regex1_i.match(expr);
        if (rMap != null) {
            Var var = ((Expr)rMap.get(Var.alloc((String)"a1"))).getExprVar().asVar();
            String pattern = ((Expr)rMap.get(Var.alloc((String)"a2"))).getConstant().getString();
            return new RegexSqlGen(expr, regex1_i, pattern, "i", true);
        }
        return null;
    }
}

