/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.layout2.hash;

import java.sql.SQLException;
import org.apache.jena.sdb.layout2.FmtLayout2;
import org.apache.jena.sdb.layout2.TableDescNodes;
import org.apache.jena.sdb.layout2.TableDescQuads;
import org.apache.jena.sdb.layout2.TableDescTriples;
import org.apache.jena.sdb.layout2.TablePrefixes;
import org.apache.jena.sdb.sql.SDBConnection;
import org.apache.jena.sdb.sql.SDBExceptionSQL;
import org.apache.jena.sdb.sql.SQLUtils;

public class FmtLayout2HashDerby
extends FmtLayout2 {
    public FmtLayout2HashDerby(SDBConnection connection) {
        super(connection);
    }

    @Override
    protected void formatTableTriples() {
        this.dropTable(TableDescTriples.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TableDescTriples.name() + " (", "    s BIGINT NOT NULL,", "    p BIGINT NOT NULL,", "    o BIGINT NOT NULL,", "    PRIMARY KEY (s, p, o)", ")"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescTriples.name() + "'", ex);
        }
    }

    @Override
    protected void formatTableQuads() {
        this.dropTable(TableDescQuads.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TableDescQuads.name() + " (", "    g BIGINT NOT NULL,", "    s BIGINT NOT NULL,", "    p BIGINT NOT NULL,", "    o BIGINT NOT NULL,", "    PRIMARY KEY (g, s, p, o)", ")"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescTriples.name() + "'", ex);
        }
    }

    @Override
    protected void formatTableNodes() {
        this.dropTable(TableDescNodes.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TableDescNodes.name() + " (", "   hash BIGINT NOT NULL ,", "   lex CLOB NOT NULL ,", "   lang LONG VARCHAR NOT NULL ,", "   datatype LONG VARCHAR NOT NULL ,", "   type integer NOT NULL ,", "   PRIMARY KEY (hash)", ")"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException resetting table '" + TableDescNodes.name() + "'", ex);
        }
    }

    @Override
    protected void formatTablePrefixes() {
        this.dropTable(TablePrefixes.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TablePrefixes.name() + " (", "    prefix VARCHAR(50) NOT NULL ,", "    uri VARCHAR(500) NOT NULL ,", "    PRIMARY KEY  (prefix)", ")"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException resetting table '" + TablePrefixes.name() + "'", ex);
        }
    }
}

