/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.layout2.hash;

import java.sql.SQLException;
import org.apache.jena.sdb.layout2.FmtLayout2;
import org.apache.jena.sdb.layout2.TableDescNodes;
import org.apache.jena.sdb.layout2.TableDescQuads;
import org.apache.jena.sdb.layout2.TableDescTriples;
import org.apache.jena.sdb.layout2.TablePrefixes;
import org.apache.jena.sdb.sql.MySQLEngineType;
import org.apache.jena.sdb.sql.SDBConnection;
import org.apache.jena.sdb.sql.SDBExceptionSQL;
import org.apache.jena.sdb.sql.SQLUtils;
import org.apache.jena.sdb.sql.TableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FmtLayout2HashHSQL
extends FmtLayout2 {
    private static Logger log = LoggerFactory.getLogger(FmtLayout2HashHSQL.class);
    private MySQLEngineType engineType;

    public FmtLayout2HashHSQL(SDBConnection connection) {
        super(connection);
    }

    @Override
    protected void formatTableTriples() {
        this.dropTable(TableDescTriples.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TableDescTriples.name() + " (", "    s BIGINT NOT NULL ,", "    p BIGINT NOT NULL ,", "    o BIGINT NOT NULL ,", "    PRIMARY KEY (s, p, o)", ")"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescTriples.name() + "'", ex);
        }
    }

    @Override
    protected void formatTableQuads() {
        this.dropTable(TableDescQuads.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TableDescQuads.name() + " (", "    g BIGINT NOT NULL ,", "    s BIGINT NOT NULL ,", "    p BIGINT NOT NULL ,", "    o BIGINT NOT NULL ,", "    PRIMARY KEY (g, s, p, o)", ")"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescQuads.name() + "'", ex);
        }
    }

    @Override
    protected String syntaxDropIndex(String indexName, String table) {
        return String.format("DROP INDEX %s IF EXIST", indexName);
    }

    @Override
    protected void formatTableNodes() {
        this.dropTable(TableDescNodes.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TableDescNodes.name() + " (", "   hash BIGINT NOT NULL ,", "   lex VARCHAR NOT NULL ,", "   lang VARCHAR(10) default '' NOT NULL ,", "   datatype VARCHAR default '' NOT NULL ,", "   type int default 0 NOT NULL ,", "   PRIMARY KEY (hash)", ")"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException resetting table '" + TableDescNodes.name() + "'", ex);
        }
    }

    @Override
    protected void formatTablePrefixes() {
        this.dropTable(TablePrefixes.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE TABLE " + TablePrefixes.name() + " (", "    prefix  VARCHAR NOT NULL,", "    uri     VARCHAR NOT NULL,", "    PRIMARY KEY  (prefix)", ")"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException resetting table '" + TablePrefixes.name() + "'", ex);
        }
    }

    @Override
    protected void truncateTable(String tableName) {
        try {
            if (TableUtils.hasTable(this.connection().getSqlConnection(), tableName, new String[0])) {
                this.connection().exec("DELETE FROM " + tableName);
            }
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException : Can't truncate table: " + tableName, ex);
        }
    }
}

