/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.script;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sdb.assembler.AssemblerVocab;
import org.apache.jena.sdb.assembler.CommandAssemblerException;
import org.apache.jena.sdb.script.CmdDesc;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.jena.vocabulary.RDF;

public class CmdDescAssembler
extends AssemblerBase
implements Assembler {
    public Object open(Assembler a, Resource root, Mode mode) {
        CmdDesc cd = new CmdDesc();
        String main = GraphUtils.getStringValue((Resource)root, (Property)AssemblerVocab.pMain);
        if (main == null) {
            main = GraphUtils.getStringValue((Resource)root, (Property)AssemblerVocab.pClassname);
        }
        cd.setCmd(main);
        Resource x = GraphUtils.getResourceValue((Resource)root, (Property)AssemblerVocab.pArgs);
        if (x != null) {
            while (!x.equals((Object)RDF.nil)) {
                RDFNode e = x.getRequiredProperty(RDF.first).getObject();
                x = x.getRequiredProperty(RDF.rest).getResource();
                if (e.isLiteral()) {
                    cd.addPosn(((Literal)e).getString());
                    continue;
                }
                Resource entry = (Resource)e;
                String name = GraphUtils.getStringValue((Resource)entry, (Property)AssemblerVocab.pArgName);
                String value = GraphUtils.getStringValue((Resource)entry, (Property)AssemblerVocab.pArgValue);
                if (value == null) {
                    throw new CommandAssemblerException(entry, "Strange entry: " + entry);
                }
                if (name != null) {
                    cd.addNamedArg(name, value);
                    continue;
                }
                cd.addPosn(value);
            }
        }
        return cd;
    }
}

