/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.script;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.sdb.assembler.AssemblerVocab;
import org.apache.jena.sdb.script.CmdDescAssembler;
import org.apache.jena.sdb.script.ScriptAssembler;

public class ScriptVocab {
    static final String NS = AssemblerVocab.getURI();
    public static final Resource CommandLineType = ScriptVocab.type(NS, "Cmd");
    public static final Resource ScriptType = ScriptVocab.type(NS, "Script");
    public static final Resource DatasetAssemblerType = ScriptVocab.type(NS, "Dataset");
    private static boolean initialized = false;

    public static void init() {
        if (initialized) {
            return;
        }
        ScriptVocab.assemblerClass(CommandLineType, new CmdDescAssembler());
        ScriptVocab.assemblerClass(ScriptType, new ScriptAssembler());
        initialized = true;
    }

    private static void assemblerClass(Resource r, Assembler a) {
        Assembler.general.implementWith(r, a);
    }

    private static Resource type(String namespace, String localName) {
        return ResourceFactory.createResource((String)(namespace + localName));
    }

    private static Property property(String namespace, String localName) {
        return ResourceFactory.createProperty((String)(namespace + localName));
    }

    static {
        ScriptVocab.init();
    }
}

