/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.sql;

import java.sql.Timestamp;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.jena.sdb.sql.SQLUtils;
import org.slf4j.LoggerFactory;

public class FunctionsSQL {
    public static boolean sqlSafeChar(String str) {
        if (!FunctionsSQL.isLowerCaseSqlChar(str.charAt(0))) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (FunctionsSQL.isLowerCaseSqlChar(ch) || FunctionsSQL.isSqlDigit(ch)) continue;
            return false;
        }
        return true;
    }

    public static String replace(String str, String[] fromArray, String[] toArray) {
        for (int i = 0; i < fromArray.length; ++i) {
            str = str.replace(fromArray[i], toArray[i]);
        }
        return str;
    }

    public static boolean isLowerCaseSqlChar(char ch) {
        return ch >= 'a' && ch <= 'z';
    }

    public static boolean isSqlDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static String toSQLdatetimeString(String lex) {
        try {
            DatatypeFactory f = DatatypeFactory.newInstance();
            XMLGregorianCalendar cal = f.newXMLGregorianCalendar(lex);
            long millis = cal.toGregorianCalendar().getTimeInMillis();
            Timestamp timestamp = new Timestamp(millis);
            return timestamp.toString();
        }
        catch (DatatypeConfigurationException e) {
            LoggerFactory.getLogger(SQLUtils.class).warn("Failed to convert " + lex, (Throwable)e);
            return "0000-00-00 00:00:00";
        }
    }
}

