/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.sql;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sdb.SDBException;
import org.apache.jena.sdb.sql.DataSourceSDB;
import org.apache.jena.sdb.sql.JDBC;
import org.apache.jena.sdb.sql.SDBConnection;
import org.apache.jena.sdb.sql.SDBConnectionDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDBConnectionFactory {
    private static Logger log = LoggerFactory.getLogger(SDBConnectionFactory.class);

    public static SDBConnection create(SDBConnectionDesc desc) {
        return SDBConnectionFactory.worker(desc);
    }

    public static SDBConnection create(String configFile) {
        SDBConnectionDesc desc = SDBConnectionDesc.read(configFile);
        return SDBConnectionFactory.create(desc);
    }

    public static SDBConnection create(String url, String user, String password) {
        return new SDBConnection(SDBConnectionFactory.createSqlConnection(url, user, password));
    }

    public static Connection createJDBC(String configFile) {
        SDBConnectionDesc desc = SDBConnectionDesc.read(configFile);
        return SDBConnectionFactory.createSqlConnection(desc);
    }

    public static Connection createJDBC(Model model) {
        SDBConnectionDesc desc = SDBConnectionDesc.read(model);
        return SDBConnectionFactory.createSqlConnection(desc);
    }

    public static SDBConnection create(Connection sqlConnection) {
        return new SDBConnection(sqlConnection);
    }

    public static DataSource createDataSource(String configFile) {
        SDBConnectionDesc desc = SDBConnectionDesc.read(configFile);
        return new DataSourceSDB(desc);
    }

    private static SDBConnection worker(SDBConnectionDesc desc) {
        return SDBConnectionFactory.makeSDBConnection(desc);
    }

    private static SDBConnection makeSDBConnection(SDBConnectionDesc desc) {
        Connection sqlConnection = SDBConnectionFactory.createSqlConnection(desc);
        SDBConnection c = new SDBConnection(sqlConnection, desc.getJdbcURL());
        if (desc.getLabel() != null) {
            c.setLabel(desc.getLabel());
        } else {
            c.setLabel(desc.getJdbcURL());
        }
        return c;
    }

    public static Connection createSqlConnection(SDBConnectionDesc desc) {
        if (desc.getDriver() != null) {
            JDBC.loadDriver(desc.getDriver());
        } else if (!desc.getJdbcURL().equals("jdbc:none")) {
            String driver = desc.getDriver();
            if (driver == null) {
                driver = JDBC.guessDriver(desc.getType());
            }
            if (driver != null) {
                JDBC.loadDriver(driver);
            }
        }
        return SDBConnectionFactory.createSqlConnection(desc.getJdbcURL(), desc.getUser(), desc.getPassword());
    }

    public static Connection createSqlConnection(String jdbcURL, String user, String password) {
        try {
            return JDBC.createConnection(jdbcURL, user, password);
        }
        catch (SQLException e) {
            SQLException e2 = e.getNextException();
            String more = "";
            if (e2 != null) {
                more = " : " + e2.getMessage();
            }
            throw new SDBException("SQL Exception while connecting to database: " + jdbcURL + " : " + e.getMessage() + more);
        }
    }
}

