/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.sdb.sql.RS;
import org.apache.jena.sdb.sql.ResultSetJDBC;
import org.apache.jena.sdb.sql.SDBConnection;
import org.apache.jena.sdb.sql.SDBConnectionHolder;
import org.apache.jena.sdb.sql.SDBExceptionSQL;

public class TableUtils {
    public static void dump(SDBConnection conn, String tableName) {
        ResultSetJDBC tableData = null;
        try {
            tableData = conn.execQuery("SELECT * FROM " + tableName);
            RS.printResultSet(tableData.get());
            tableData.close();
        }
        catch (SQLException ex) {
            try {
                throw new SDBExceptionSQL(ex);
            }
            catch (Throwable throwable) {
                RS.close(tableData);
                throw throwable;
            }
        }
        RS.close(tableData);
    }

    public static void dump(Connection conn, String tableName) {
        try {
            Statement s = conn.createStatement();
            try (ResultSet tableData = s.executeQuery("SELECT * FROM " + tableName);){
                RS.printResultSet(tableData);
                tableData.close();
            }
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL(ex);
        }
    }

    public static boolean hasTable(Connection connection, String table, String ... types) throws SQLException {
        if (types.length == 0) {
            types = null;
        }
        boolean hasTable = false;
        try (ResultSet tableData = connection.getMetaData().getTables(null, null, table, types);){
            hasTable = tableData.next();
        }
        if (!hasTable) {
            tableData = connection.getMetaData().getTables(null, null, table.toLowerCase(), types);
            var5_5 = null;
            try {
                hasTable = tableData.next();
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
            finally {
                if (tableData != null) {
                    if (var5_5 != null) {
                        try {
                            tableData.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        tableData.close();
                    }
                }
            }
        }
        if (!hasTable) {
            tableData = connection.getMetaData().getTables(null, null, table.toUpperCase(), types);
            var5_5 = null;
            try {
                hasTable = tableData.next();
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
            finally {
                if (tableData != null) {
                    if (var5_5 != null) {
                        try {
                            tableData.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        tableData.close();
                    }
                }
            }
        }
        return hasTable;
    }

    public static boolean hasTable(SDBConnectionHolder holder, String table, String ... types) throws SQLException {
        return TableUtils.hasTable(holder.connection().getSqlConnection(), table, types);
    }

    public static List<String> getTableNames(Connection connection) {
        return TableUtils.getTableNames(connection, "TABLE");
    }

    public static List<String> getTableNames(Connection connection, String tableTypeName) {
        try {
            ArrayList<String> tableNames = new ArrayList<String>();
            ResultSet rs = connection.getMetaData().getTables(null, null, null, new String[]{tableTypeName});
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                tableNames.add(tableName);
            }
            return tableNames;
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL(ex);
        }
    }

    public static long getTableSize(Connection connection, String table) {
        long size = -1L;
        try (ResultSet res = connection.createStatement().executeQuery("SELECT COUNT(*) FROM " + table);){
            if (res.next()) {
                size = res.getLong(1);
            }
        }
        catch (SQLException e) {
            throw new SDBExceptionSQL(e);
        }
        return size;
    }

    public static void dropTable(SDBConnection connection, String tableName) {
        try {
            if (TableUtils.hasTable(connection.getSqlConnection(), tableName, new String[0])) {
                connection.execSilent("DROP TABLE " + tableName);
            }
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException : Can't drop table: " + tableName, ex);
        }
    }

    public static void dropTableSilent(SDBConnection connection, String tableName) {
        connection.execSilent("DROP TABLE " + tableName);
    }
}

