/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.assembler;

import java.util.List;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sdb.SDBException;
import org.apache.jena.sdb.StoreDesc;
import org.apache.jena.sdb.assembler.AssemblerVocab;
import org.apache.jena.sdb.sql.MySQLEngineType;
import org.apache.jena.sdb.sql.SAPStorageType;
import org.apache.jena.sdb.sql.SDBConnectionDesc;
import org.apache.jena.sdb.store.Feature;
import org.apache.jena.sdb.store.FeatureSet;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreDescAssembler
extends AssemblerBase
implements Assembler {
    private static Logger log = LoggerFactory.getLogger(StoreDescAssembler.class);

    public StoreDesc open(Assembler a, Resource root, Mode mode) {
        String storageType;
        SDBConnectionDesc sdbConnDesc = null;
        Resource c = GraphUtils.getResourceValue((Resource)root, (Property)AssemblerVocab.pConnection);
        if (c != null) {
            sdbConnDesc = (SDBConnectionDesc)a.open(c);
        }
        String layoutName = GraphUtils.getStringValue((Resource)root, (Property)AssemblerVocab.pLayout);
        String dbType = this.chooseDBType(root, sdbConnDesc);
        List x = GraphUtils.multiValueResource((Resource)root, (Property)AssemblerVocab.featureProperty);
        FeatureSet fSet = new FeatureSet();
        for (Resource r : x) {
            String n = GraphUtils.getStringValue((Resource)r, (Property)AssemblerVocab.featureNameProperty);
            String v = GraphUtils.getStringValue((Resource)r, (Property)AssemblerVocab.featureValueProperty);
            Feature f = new Feature(new Feature.Name(n), v);
            fSet.addFeature(f);
        }
        StoreDesc storeDesc = new StoreDesc(layoutName, dbType, fSet);
        storeDesc.connDesc = sdbConnDesc;
        String engineName = GraphUtils.getStringValue((Resource)root, (Property)AssemblerVocab.pMySQLEngine);
        storeDesc.engineType = null;
        if (engineName != null) {
            try {
                storeDesc.engineType = MySQLEngineType.convert(engineName);
            }
            catch (SDBException n) {
                // empty catch block
            }
        }
        if ((storageType = GraphUtils.getStringValue((Resource)root, (Property)AssemblerVocab.pStorageType)) != null) {
            try {
                storeDesc.storageType = SAPStorageType.convert(storageType);
            }
            catch (SDBException sDBException) {
                // empty catch block
            }
        }
        return storeDesc;
    }

    private String chooseDBType(Resource root, SDBConnectionDesc sdbConnDesc) {
        String dbTypeConn = sdbConnDesc != null ? sdbConnDesc.getType() : null;
        String dbType = GraphUtils.getStringValue((Resource)root, (Property)AssemblerVocab.pSDBtype);
        if (dbTypeConn != null && dbType != null) {
            if (!dbTypeConn.equals(dbType)) {
                String $ = String.format("Connection-specified DB type and store description dbtype are different : %s %s", dbTypeConn, dbType);
                log.warn($);
            }
        } else if (dbType != null) {
            if (sdbConnDesc != null) {
                sdbConnDesc.setType(dbType);
            }
        } else if (dbTypeConn != null) {
            dbType = dbTypeConn;
        } else {
            log.warn("Failed to determine the database type (not in store description, no connection description)");
            throw new SDBException("No database type found");
        }
        return dbType;
    }
}

