/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.core.sqlnode;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.sdb.core.JoinType;
import org.apache.jena.sdb.core.sqlnode.GenerateSQLVisitor;
import org.apache.jena.sdb.core.sqlnode.SqlJoinInner;
import org.apache.jena.sdb.core.sqlnode.SqlSelectBlock;

class GeneratorVisitorMySQL
extends GenerateSQLVisitor {
    static final String InnerJoinOperatorStraight = "STRAIGHT_JOIN";
    static final String InnerJoinOperatorDefault = JoinType.INNER.sqlOperator();

    public GeneratorVisitorMySQL(IndentedWriter out) {
        super(out);
    }

    @Override
    public void visit(SqlJoinInner join) {
        join = this.rewrite(join);
        this.visitJoin(join, InnerJoinOperatorDefault);
    }

    @Override
    protected void genLimitOffset(SqlSelectBlock sqlSelectBlock) {
        if (sqlSelectBlock.getLength() >= 0L || sqlSelectBlock.getStart() >= 0L) {
            long length = sqlSelectBlock.getLength();
            if (length < 0L) {
                sqlSelectBlock.addNote("Require large LIMIT");
                length = Long.MAX_VALUE;
            }
            this.out.println("LIMIT " + length);
            if (sqlSelectBlock.getStart() >= 0L) {
                this.out.println("OFFSET " + sqlSelectBlock.getStart());
            }
        }
    }
}

