/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.layout2.hash;

import org.apache.jena.sdb.layout2.TupleLoaderBase;
import org.apache.jena.sdb.sql.SDBConnection;
import org.apache.jena.sdb.store.TableDesc;

public abstract class TupleLoaderHashBase
extends TupleLoaderBase {
    public TupleLoaderHashBase(SDBConnection connection, TableDesc tableDesc, int chunkSize) {
        super(connection, tableDesc, chunkSize);
    }

    @Override
    public String getLoadTuples() {
        int i;
        StringBuilder stmt = new StringBuilder();
        stmt.append("INSERT INTO ").append(this.getTableName()).append(" \nSELECT DISTINCT ");
        for (i = 0; i < this.getTableWidth(); ++i) {
            if (i != 0) {
                stmt.append(" , ");
            }
            stmt.append(this.getTupleLoader()).append(".").append("t").append(i);
        }
        stmt.append("\nFROM ").append(this.getTupleLoader()).append(" LEFT JOIN ").append(this.getTableName()).append(" ON \n (");
        for (i = 0; i < this.getTableWidth(); ++i) {
            if (i != 0) {
                stmt.append(" AND ");
            }
            stmt.append("t").append(i);
            stmt.append("=").append(this.getTableName()).append(".").append(this.getTableDesc().getColNames().get(i));
        }
        stmt.append(")\nWHERE\n");
        for (i = 0; i < this.getTableWidth(); ++i) {
            if (i != 0) {
                stmt.append(" OR\n");
            }
            stmt.append(this.getTableName()).append(".").append(this.getTableDesc().getColNames().get(i)).append(" IS NULL");
        }
        return stmt.toString();
    }

    @Override
    public String getDeleteTuples() {
        StringBuilder stmt = new StringBuilder();
        stmt.append("DELETE FROM ").append(this.getTableName()).append(" \nWHERE\n");
        for (int i = 0; i < this.getTableWidth(); ++i) {
            if (i != 0) {
                stmt.append(" AND\n");
            }
            stmt.append(this.getTableDesc().getColNames().get(i)).append(" = ?");
        }
        return stmt.toString();
    }

    @Override
    public String getDeleteAllTuples() {
        StringBuilder stmt = new StringBuilder();
        stmt.append("DELETE FROM ").append(this.getTableName());
        if (this.getTableWidth() != 3) {
            stmt.append(" \nWHERE\n");
            stmt.append(this.getTableDesc().getColNames().get(0));
            stmt.append(" = ? ");
        }
        return stmt.toString();
    }
}

