/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.layout2.hash;

import org.apache.jena.sdb.layout2.hash.TupleLoaderHashBase;
import org.apache.jena.sdb.sql.SDBConnection;
import org.apache.jena.sdb.store.TableDesc;

public class TupleLoaderHashMySQL
extends TupleLoaderHashBase {
    public TupleLoaderHashMySQL(SDBConnection connection, TableDesc tableDesc, int chunkSize) {
        super(connection, tableDesc, chunkSize);
    }

    @Override
    public String[] getNodeColTypes() {
        return new String[]{"BIGINT", "LONGTEXT BINARY CHARACTER SET utf8", "VARCHAR(10) BINARY CHARACTER SET utf8", "VARCHAR(200) BINARY CHARACTER SET utf8", "INT"};
    }

    @Override
    public String getTupleColType() {
        return "BIGINT";
    }

    @Override
    public String[] getCreateTempTable() {
        return new String[]{"CREATE TEMPORARY TABLE", "ENGINE=MYISAM"};
    }

    @Override
    public String getLoadNodes() {
        StringBuilder stmt = new StringBuilder();
        stmt.append("INSERT IGNORE INTO Nodes (hash, lex, lang, datatype, type) \nSELECT ");
        for (int i = 0; i < this.getNodeColTypes().length; ++i) {
            if (i != 0) {
                stmt.append(" , ");
            }
            stmt.append("n").append(i);
        }
        stmt.append("\nFROM ").append(this.getNodeLoader());
        return stmt.toString();
    }

    @Override
    public String getLoadTuples() {
        StringBuilder stmt = new StringBuilder();
        stmt.append("INSERT IGNORE INTO ").append(this.getTableName()).append(" \nSELECT ");
        for (int i = 0; i < this.getTableWidth(); ++i) {
            if (i != 0) {
                stmt.append(" , ");
            }
            stmt.append("t").append(i);
        }
        stmt.append("\nFROM ").append(this.getTupleLoader());
        return stmt.toString();
    }
}

