/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.layout2.index;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.jena.graph.Node;
import org.apache.jena.sdb.StoreDesc;
import org.apache.jena.sdb.compiler.QueryCompilerFactory;
import org.apache.jena.sdb.layout2.NodeLayout2;
import org.apache.jena.sdb.layout2.StoreBase;
import org.apache.jena.sdb.layout2.TableDescQuads;
import org.apache.jena.sdb.layout2.TableDescTriples;
import org.apache.jena.sdb.layout2.index.TableNodesIndex;
import org.apache.jena.sdb.sql.RS;
import org.apache.jena.sdb.sql.ResultSetJDBC;
import org.apache.jena.sdb.sql.SDBConnection;
import org.apache.jena.sdb.sql.SDBExceptionSQL;
import org.apache.jena.sdb.store.SQLBridgeFactory;
import org.apache.jena.sdb.store.SQLGenerator;
import org.apache.jena.sdb.store.StoreFormatter;
import org.apache.jena.sdb.store.StoreLoader;
import org.apache.jena.sparql.util.NodeUtils;

public class StoreBaseIndex
extends StoreBase {
    public StoreBaseIndex(SDBConnection connection, StoreDesc desc, StoreFormatter formatter, StoreLoader loader, QueryCompilerFactory compilerF, SQLBridgeFactory sqlBridgeF, SQLGenerator sqlGenerator) {
        super(connection, desc, formatter, loader, compilerF, sqlBridgeF, sqlGenerator, new TableDescTriples(), new TableDescQuads(), new TableNodesIndex());
    }

    @Override
    public long getSize(Node node) {
        return StoreBaseIndex.getSize(this.getConnection(), this.getQuadTableDesc(), node);
    }

    public static long getSize(SDBConnection connection, TableDescQuads tableDescQuads, Node node) {
        long l;
        int id;
        ResultSet res;
        ResultSetJDBC rsx;
        block8: {
            String lex = NodeLayout2.nodeToLex(node);
            int typeId = NodeLayout2.nodeToType(node);
            String lang = "";
            String datatype = "";
            if (node.isLiteral()) {
                lang = node.getLiteralLanguage();
                datatype = node.getLiteralDatatypeURI();
                if (NodeUtils.isSimpleString((Node)node) || NodeUtils.isLangString((Node)node)) {
                    datatype = "";
                }
            }
            rsx = null;
            long hash = NodeLayout2.hash(lex, lang, datatype, typeId);
            rsx = connection.exec("SELECT id FROM Nodes WHERE hash = " + hash);
            res = rsx.get();
            id = -1;
            if (res.next()) {
                id = res.getInt(1);
                break block8;
            }
            long l2 = 0L;
            RS.close(rsx);
            return l2;
        }
        try {
            long result;
            rsx.close();
            rsx = connection.exec("SELECT COUNT(*) FROM " + tableDescQuads.getTableName() + " WHERE g = " + id);
            res = rsx.get();
            res.next();
            l = result = res.getLong(1);
        }
        catch (SQLException e) {
            try {
                throw new SDBExceptionSQL("Failed to get graph size", e);
            }
            catch (Throwable throwable) {
                RS.close(rsx);
                throw throwable;
            }
        }
        RS.close(rsx);
        return l;
    }
}

