/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.layout2.index;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.sdb.SDBException;
import org.apache.jena.sdb.Store;
import org.apache.jena.sdb.core.sqlexpr.SqlConstant;
import org.apache.jena.sdb.layout2.NodeLayout2;
import org.apache.jena.sdb.layout2.TableDescNodes;
import org.apache.jena.sdb.sql.RS;
import org.apache.jena.sdb.sql.ResultSetJDBC;
import org.apache.jena.sdb.sql.SDBConnection;
import org.apache.jena.sdb.sql.SQLUtils;
import org.apache.jena.sdb.store.TableDesc;
import org.apache.jena.sdb.store.TupleLoaderOne;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TupleLoaderOneIndex
extends TupleLoaderOne {
    private static Logger log = LoggerFactory.getLogger(TupleLoaderOneIndex.class);

    public TupleLoaderOneIndex(SDBConnection connection) {
        super(connection);
    }

    public TupleLoaderOneIndex(SDBConnection connection, TableDesc tableDesc) {
        super(connection, tableDesc);
    }

    public TupleLoaderOneIndex(Store store, TableDesc tableDesc) {
        super(store.getConnection(), tableDesc);
    }

    @Override
    public SqlConstant getRefForNode(Node node) throws SQLException {
        return new SqlConstant(TupleLoaderOneIndex.getIndex(this.connection(), node, false));
    }

    @Override
    public SqlConstant insertNode(Node node) throws SQLException {
        return new SqlConstant(TupleLoaderOneIndex.getIndex(this.connection(), node, true));
    }

    private static int getIndex(SDBConnection conn, Node node, boolean create) throws SQLException {
        long hash = NodeLayout2.hash(node);
        String lex = NodeLayout2.nodeToLex(node);
        String hashStr = Long.toString(hash);
        String sqlStmt = "SELECT id FROM Nodes WHERE hash = " + hashStr;
        ResultSetJDBC rsx = null;
        try {
            rsx = conn.execQuery(sqlStmt);
            ResultSet rs = rsx.get();
            if (!rs.next()) {
                if (!create) {
                    throw new SDBException("No such node in table: " + node);
                }
                TupleLoaderOneIndex.insertNode(conn, lex, node);
                int n = TupleLoaderOneIndex.getIndex(conn, node, false);
                return n;
            }
            int id = rs.getInt("id");
            if (rs.next()) {
                log.warn("More than one hit for : " + sqlStmt + " (ignored)");
            }
            int n = id;
            return n;
        }
        catch (SQLException ex) {
            log.warn("SQLException: " + ex.getMessage());
            throw ex;
        }
        finally {
            RS.close(rsx);
        }
    }

    private static void insertNode(SDBConnection conn, String lex, Node node) throws SQLException {
        int typeId = NodeLayout2.nodeToType(node);
        String lang = "";
        String datatype = "";
        if (node.isLiteral()) {
            lang = node.getLiteralLanguage();
            datatype = node.getLiteralDatatypeURI();
            if (datatype == null) {
                datatype = "";
            }
        }
        long hash = NodeLayout2.hash(lex, lang, datatype, typeId);
        String sqlStmt = StrUtils.strjoinNL((String[])new String[]{"INSERT INTO " + TableDescNodes.name() + "(hash,lex,lang,datatype,type) VALUES", "  (" + hash + ", ", "   " + SQLUtils.quoteStr(lex) + ", ", "   " + SQLUtils.quoteStr(lang) + ", ", "   " + SQLUtils.quoteStr(datatype) + ", ", "   " + typeId, ")"});
        conn.execUpdate(sqlStmt);
    }
}

