/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.script;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sdb.SDBException;
import org.apache.jena.sdb.assembler.AssemblerVocab;
import org.apache.jena.sdb.script.CmdDesc;
import org.apache.jena.sdb.script.ScriptVocab;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.jena.util.FileManager;

public class ScriptDesc {
    List<CmdDesc> steps = new ArrayList<CmdDesc>();

    public static ScriptDesc read(String filename) {
        AssemblerVocab.init();
        Model m = FileManager.get().loadModel(filename);
        return ScriptDesc.worker(m);
    }

    public static void run(String filename) {
        ScriptDesc desc = ScriptDesc.read(filename);
    }

    public void add(CmdDesc step) {
        this.steps.add(step);
    }

    public List<CmdDesc> getSteps() {
        return this.steps;
    }

    private static ScriptDesc worker(Model m) {
        Resource r = GraphUtils.getResourceByType((Model)m, (Resource)ScriptVocab.ScriptType);
        if (r == null) {
            throw new SDBException("Can't find command line description");
        }
        return (ScriptDesc)AssemblerBase.general.open(r);
    }
}

