/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.jena.sdb.SDBException;
import org.apache.jena.sdb.shared.Access;
import org.apache.jena.sdb.shared.SDBNotFoundException;
import org.apache.jena.sdb.store.DatabaseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBC {
    private static Logger log = LoggerFactory.getLogger(JDBC.class);
    public static final String jdbcNone = "jdbc:none";
    public static final String jdbcDriverClassMySQL;
    public static final String jdbcDriverClassMariaDB;
    private static Map<DatabaseType, String> driver;

    public static String getDriver(DatabaseType dbType) {
        return driver.get((Object)dbType);
    }

    public static void loadDriverHSQL() {
        JDBC.loadDriver(driver.get((Object)DatabaseType.HSQLDB));
    }

    public static void loadDriverH2() {
        JDBC.loadDriver(driver.get((Object)DatabaseType.H2));
    }

    public static void loadDriverMySQL() {
        JDBC.loadDriver(driver.get((Object)DatabaseType.MySQL));
    }

    public static void loadDriverMariaDB() {
        JDBC.loadDriver(driver.get((Object)DatabaseType.MariaDB));
    }

    public static void loadDriverPGSQL() {
        JDBC.loadDriver(driver.get((Object)DatabaseType.PostgreSQL));
    }

    public static void loadDriverDerby() {
        JDBC.loadDriver(driver.get((Object)DatabaseType.Derby));
    }

    public static void loadDriverSQLServer() {
        JDBC.loadDriver(driver.get((Object)DatabaseType.SQLServer));
    }

    public static void loadDriverOracle() {
        JDBC.loadDriver(driver.get((Object)DatabaseType.Oracle));
    }

    public static void loadDriverDB2() {
        JDBC.loadDriver(driver.get((Object)DatabaseType.DB2));
    }

    public static void loadDriverSAP() {
        JDBC.loadDriver(driver.get((Object)DatabaseType.SAP));
    }

    public static void loadDriver(String className) {
        JDBC.loadClass(className);
    }

    public static String guessDriver(String type) {
        return JDBC.getDriver(DatabaseType.fetch(type));
    }

    public static Connection createConnection(String url, String user, String password) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("Create JDBC connection: " + url);
        }
        if (url.equals(jdbcNone)) {
            return null;
        }
        if (user == null) {
            user = Access.getUser();
        }
        if (password == null) {
            password = Access.getPassword();
        }
        return DriverManager.getConnection(url, user, password);
    }

    private static void loadClass(String className) {
        try {
            Class.forName(className);
            return;
        }
        catch (ClassNotFoundException ex) {
            if (className.equals(jdbcDriverClassMySQL) || className.equals(jdbcDriverClassMariaDB)) {
                String classNameAlt = null;
                if (className.equals(jdbcDriverClassMySQL)) {
                    classNameAlt = jdbcDriverClassMariaDB;
                } else if (className.equals(jdbcDriverClassMariaDB)) {
                    classNameAlt = jdbcDriverClassMySQL;
                }
                try {
                    Class.forName(classNameAlt);
                    return;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw new SDBNotFoundException("Class.forName(" + className + ")", ex);
        }
    }

    public static String makeURL(String type, String host, String dbName) {
        return JDBC.makeURL(type, host, dbName, null, null);
    }

    public static String makeURL(String type, String host, String dbName, String user, String password) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Create JDBC URL: (type=%s, host=%s, dbName=%s)", type, host, dbName));
        }
        type = type.toLowerCase(Locale.ENGLISH);
        if (user == null) {
            user = Access.getUser();
        }
        if (password == null) {
            password = Access.getPassword();
        }
        if (type.equals("mysql") || type.equals("mariadb")) {
            type = "mysql";
            String s = String.format("jdbc:%s://%s/%s", type, host, dbName);
            return s;
        }
        if (type.startsWith("hsql")) {
            String s = String.format("jdbc:%s:%s:%s", type, host, dbName);
            return s;
        }
        if (type.startsWith("h2")) {
            if (type.startsWith("h2:tcp") || type.startsWith("h2:ssl")) {
                String s = String.format("jdbc:%s://%s/%s", type, host, dbName);
                return s;
            }
            String s = String.format("jdbc:%s:%s", type, dbName);
            return s;
        }
        if (type.startsWith("pgsql") || type.equals("postgresql")) {
            String s = String.format("jdbc:%s://%s/%s", type, host, dbName);
            return s;
        }
        if (type.equals("derby")) {
            String s = String.format("jdbc:%s:%s;create=true", type, dbName);
            return s;
        }
        if (type.equals("mssqlserver") || type.equals("sqlserver")) {
            String s = String.format("jdbc:%s://%s;databaseName=%s", "sqlserver", host, dbName);
            return s;
        }
        if (type.equals("mssqlserverexpress") || type.equals("sqlserverexpress")) {
            String s = String.format("jdbc:%s://%s\\SQLEXPRESS;databaseName=%s", "sqlserver", host, dbName);
            return s;
        }
        if (type.startsWith("oracle:")) {
            String s = String.format("jdbc:%s:@%s:%s", type, host, dbName);
            return s;
        }
        if (type.equals("oracle")) {
            String s = String.format("jdbc:%s:thin:@%s:%s", type, host, dbName);
            return s;
        }
        if (type.equals("db2")) {
            String s = String.format("jdbc:%s://%s/%s", type, host, dbName);
            return s;
        }
        if (type.equals("sap")) {
            String s = String.format("jdbc:%s://%s:3%s15", type, host, dbName);
            return s;
        }
        if (type.equals("none")) {
            return jdbcNone;
        }
        throw new SDBException("Don't know how to construct a JDBC URL for " + type);
    }

    static {
        driver = new HashMap<DatabaseType, String>();
        driver.put(DatabaseType.MySQL, "com.mysql.jdbc.Driver");
        driver.put(DatabaseType.MariaDB, "org.mariadb.jdbc.Driver");
        driver.put(DatabaseType.PostgreSQL, "org.postgresql.Driver");
        driver.put(DatabaseType.H2, "org.h2.Driver");
        driver.put(DatabaseType.HSQLDB, "org.hsqldb.jdbcDriver");
        driver.put(DatabaseType.Derby, "org.apache.derby.jdbc.EmbeddedDriver");
        driver.put(DatabaseType.SQLServer, "com.microsoft.sqlserver.jdbc.SQLServerDriver");
        driver.put(DatabaseType.Oracle, "oracle.jdbc.driver.OracleDriver");
        driver.put(DatabaseType.DB2, "com.ibm.db2.jcc.DB2Driver");
        driver.put(DatabaseType.SAP, "com.sap.db.jdbc.Driver");
        jdbcDriverClassMySQL = driver.get((Object)DatabaseType.MySQL);
        jdbcDriverClassMariaDB = driver.get((Object)DatabaseType.MariaDB);
    }
}

