/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.store;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.io.Printable;
import org.apache.jena.atlas.io.PrintableBase;
import org.apache.jena.sparql.util.Named;
import org.apache.jena.sparql.util.Symbol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Feature
extends PrintableBase
implements Named,
Printable {
    Name name;
    Object value;
    private Logger log = LoggerFactory.getLogger(Feature.class);

    private Feature(Name name) {
        this.name = name;
    }

    public Feature(Name name, String value) {
        this(name);
        this.value = value;
    }

    public Feature(Name name, long value) {
        this(name);
        this.value = value;
    }

    public Object getAsObject() {
        return this.value;
    }

    public String getAsString() {
        if (this.value instanceof String) {
            return (String)this.value;
        }
        this.log.warn("Not a string: " + (Object)((Object)this));
        return null;
    }

    public long getAsInteger() {
        if (this.value instanceof Long) {
            return (Long)this.value;
        }
        this.log.warn("Not a long: " + (Object)((Object)this));
        return -1L;
    }

    public int hashCode() {
        return this.name.hashCode() | this.value.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Feature)) {
            return false;
        }
        Feature f = (Feature)((Object)other);
        return f.name.equals((Object)this.name) && f.value.equals(this.value);
    }

    public String getName() {
        return this.name.getSymbol();
    }

    public void output(IndentedWriter out) {
        out.print(this.toString());
    }

    public String toString() {
        return (Object)((Object)this.name) + "=" + this.value;
    }

    public static class Name
    extends Symbol {
        public Name(Symbol other) {
            super(other);
        }

        public Name(String nameStr) {
            super(nameStr);
        }
    }
}

