/*
 * Decompiled with CFR 0.152.
 */
package sdb;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.List;
import jena.cmd.ArgDecl;
import jena.cmd.CmdException;
import jena.cmd.TerminationException;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sdb.SDB;
import org.apache.jena.sdb.sql.SDBConnection;
import org.apache.jena.sdb.store.StoreConfig;
import org.apache.jena.util.FileManager;
import sdb.cmd.CmdArgsDB;

public class sdbmeta
extends CmdArgsDB {
    static ArgDecl argDeclSyntax = new ArgDecl(true, new String[]{"out"});
    static ArgDecl argDeclTag = new ArgDecl(true, new String[]{"tag", "name"});
    String tag = "config";
    String format = "TTL";

    public static void main(String ... argv) {
        SDB.init();
        new sdbmeta(argv).mainRun();
    }

    protected sdbmeta(String ... argv) {
        super(argv);
        super.add(argDeclSyntax);
        super.add(argDeclTag);
    }

    protected void processModulesAndArgs() {
        if (this.contains(argDeclSyntax)) {
            this.format = this.getValue(argDeclSyntax);
        }
        if (this.contains(argDeclTag)) {
            this.tag = this.getValue(argDeclTag);
        }
        if (this.getNumPositional() == 0) {
            this.cmdError("Subcommand required (get,tags,put,remove,reset)", true);
        }
        if (this.isVerbose()) {
            SDBConnection.logSQLStatements = true;
            SDBConnection.logSQLExceptions = true;
        }
    }

    protected String getSummary() {
        return Lib.className((Object)((Object)this)) + " --sdb <SPEC> [--tag=TAG] [get|tags|put|remove|reset]";
    }

    protected String getCommandName() {
        return Lib.className((Object)((Object)this));
    }

    @Override
    protected void execCmd(List<String> positionalArgs) {
        String subCmd = positionalArgs.remove(0);
        StoreConfig conf = new StoreConfig(this.getModStore().getConnection());
        if (subCmd.equalsIgnoreCase("get")) {
            this.execGet(conf, this.tag);
        } else if (subCmd.equalsIgnoreCase("tags")) {
            this.execTags(conf);
        } else if (subCmd.equalsIgnoreCase("put")) {
            this.execPut(conf, this.tag, positionalArgs);
        } else if (subCmd.equalsIgnoreCase("remove")) {
            this.execRemove(conf, this.tag);
        } else if (subCmd.equalsIgnoreCase("reset")) {
            this.execReset(conf, this.tag);
        } else {
            this.cmdError("Subcommand not recognized: " + subCmd, true);
        }
    }

    private void execGet(StoreConfig conf, String tag) {
        Model m = conf.getModel(tag);
        if (m == null) {
            System.out.println("No configuration model");
            throw new TerminationException(1);
        }
        m.write((OutputStream)System.out, this.format);
    }

    private void execPut(StoreConfig conf, String tag, List<String> positionalArgs) {
        if (positionalArgs.size() == 0) {
            throw new CmdException("No file to load");
        }
        Model model = conf.getModel(tag);
        if (model == null) {
            model = ModelFactory.createDefaultModel();
        }
        for (String filename : positionalArgs) {
            FileManager.get().readModel(model, filename);
        }
        conf.setModel(tag, model);
    }

    private void execTags(StoreConfig conf) {
        List<String> tags = conf.getTags();
        if (tags.size() == 0) {
            System.out.println("No tags");
        } else {
            for (String tag : tags) {
                System.out.println("Tag: " + tag);
            }
        }
    }

    private void execRemove(StoreConfig conf, String name) {
        if (!this.confirm("Confirm the removal of '" + name + "'")) {
            throw new TerminationException(0);
        }
        conf.removeModel(name);
    }

    private void execReset(StoreConfig conf, String name) {
        if (!this.confirm("Confirm reset")) {
            throw new TerminationException(0);
        }
        conf.reset();
    }

    private boolean confirm(String prompt) {
        System.out.print(prompt + " [Y/n]: ");
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
            String line = r.readLine();
            return line.equalsIgnoreCase("y") || line.equalsIgnoreCase("yes");
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
            return false;
        }
    }
}

