/*
 * Decompiled with CFR 0.152.
 */
package sdb;

import java.util.ArrayList;
import java.util.List;
import jena.cmd.ArgDecl;
import jena.cmd.CmdArgModule;
import jena.cmd.CmdGeneral;
import jena.cmd.ModBase;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.sdb.SDB;
import org.apache.jena.sdb.Store;
import org.apache.jena.sdb.store.TableDesc;
import org.apache.jena.sdb.store.TupleTable;
import sdb.cmd.CmdArgsDB;

public class sdbtuple
extends CmdArgsDB {
    private static ModTuple modTuple = new ModTuple();
    private static ArgDecl argDeclCmdPrint = new ArgDecl(false, new String[]{"print"});
    private static ArgDecl argDeclCmdLoad = new ArgDecl(true, new String[]{"load"});
    private static ArgDecl argDeclCmdCreate = new ArgDecl(false, new String[]{"create"});
    private static ArgDecl argDeclCmdDrop = new ArgDecl(false, new String[]{"drop"});
    private static ArgDecl argDeclCmdTruncate = new ArgDecl(false, new String[]{"truncate"});
    private static ArgDecl argDeclCmdTable = new ArgDecl(true, new String[]{"table"});
    private boolean cmdPrint = false;
    private boolean cmdLoad = false;
    private boolean cmdCreate = false;
    private boolean cmdDrop = false;
    private boolean cmdTruncate = false;
    String loadFile = null;
    public List<String> tables = new ArrayList<String>();
    static final String divider = "- - - - - - - - - - - - - -";
    boolean needDivider = false;

    public static void main(String ... args) {
        SDB.init();
        new sdbtuple(args).mainRun();
    }

    public sdbtuple(String ... argv) {
        super(argv);
        this.getUsage().startCategory("Tuple");
        this.add(argDeclCmdTable, "--table=TableName", "Tuple table to operate on (incldues positional arguments as well)");
        this.add(argDeclCmdPrint, "--print", "Print a tuple table");
        this.add(argDeclCmdLoad, "--load", "Load a tuple table");
        this.add(argDeclCmdCreate, "--create", "Create a tuple table");
        this.add(argDeclCmdDrop, "--drop", "Drop a tuple table");
        this.add(argDeclCmdTruncate, "--truncate", "Truncate a tuple table");
    }

    private int countBool(boolean ... bools) {
        int count = 0;
        for (boolean bool : bools) {
            if (!bool) continue;
            ++count;
        }
        return count;
    }

    protected void processModulesAndArgs() {
        if (!this.contains(argDeclCmdTable) && this.getNumPositional() == 0) {
            this.cmdError("No tables specified", true);
        }
        List x = this.getPositional();
        this.tables.addAll(x);
        List y = this.getValues(argDeclCmdTable);
        this.tables.addAll(y);
        this.cmdPrint = this.contains(argDeclCmdPrint);
        this.cmdLoad = this.contains(argDeclCmdLoad);
        if (this.cmdLoad) {
            this.loadFile = this.getValue(argDeclCmdLoad);
        }
        this.cmdCreate = this.contains(argDeclCmdCreate);
        this.cmdDrop = this.contains(argDeclCmdDrop);
        this.cmdTruncate = this.contains(argDeclCmdTruncate);
    }

    protected String getSummary() {
        return this.getCommandName() + " --sdb <SPEC> [--print|--load|--create|--drop] [--table TableName] TableName...";
    }

    protected String getCommandName() {
        return Lib.className((Object)((Object)this));
    }

    private void divider() {
        if (this.needDivider) {
            System.out.println(divider);
        }
        this.needDivider = true;
    }

    @Override
    protected void execCmd(List<String> positionalArgs) {
        int count = this.countBool(this.cmdPrint, this.cmdLoad, this.cmdCreate, this.cmdDrop, this.cmdTruncate);
        if (count == 0) {
            this.cmdPrint = true;
        }
        if (count > 1) {
            this.cmdError("Too many commands : too much to do!", true);
        }
        if (this.tables.size() != 1) {
            this.cmdError("Can only operate on one table", true);
        }
        for (String tableName : this.tables) {
            this.execOne(tableName);
        }
    }

    private void execOne(String tableName) {
        if (this.cmdPrint) {
            this.execPrint(tableName);
        }
        if (this.cmdLoad) {
            this.execLoad(tableName);
        }
        if (this.cmdCreate) {
            this.cmdError("Tuple create - not implemented (yet)", true);
        }
        if (this.cmdDrop) {
            this.cmdError("Tuple drop - not implemented (yet)", true);
        }
        if (this.cmdTruncate) {
            this.cmdError("Tuple truncate - not implemented (yet)", true);
        }
    }

    private void execPrint(String tableName) {
        Store store = this.getStore();
        TupleTable table = null;
        if (tableName.equalsIgnoreCase(store.getNodeTableDesc().getTableName())) {
            TableDesc desc = new TableDesc(tableName, store.getNodeTableDesc().getNodeRefColName());
            table = new TupleTable(store, desc);
        } else {
            table = new TupleTable(store, tableName);
        }
        this.divider();
        table.dump();
    }

    private void execLoad(String tableName) {
        this.cmdError("Tuple load - not implemented (yet)", true);
        Store store = this.getStore();
        TupleTable table = null;
        if (tableName.equalsIgnoreCase(store.getNodeTableDesc().getTableName())) {
            this.cmdError("Can't load the node table as a tupole table");
        } else {
            table = new TupleTable(store, tableName);
        }
    }

    static class ModTuple
    extends ModBase {
        ModTuple() {
        }

        public void registerWith(CmdGeneral cmdLine) {
        }

        public void processArgs(CmdArgModule cmdLine) {
        }
    }
}

