/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.parser;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.shacl.engine.Target;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.parser.ShapeVisitor;
import org.apache.jena.shacl.validation.Severity;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathWriter;

public class PropertyShape
extends Shape {
    private final Path path;

    public PropertyShape(Graph shapeGraph, Node shapeNode, boolean isDeactivated, Severity severity, List<Node> messages, Collection<Target> targets, Path path, List<Constraint> constraints, List<PropertyShape> propertyShapes) {
        super(shapeGraph, shapeNode, isDeactivated, severity, messages, targets, constraints, propertyShapes);
        this.path = Objects.requireNonNull(path, "path");
    }

    @Override
    public void visit(ShapeVisitor visitor) {
        visitor.visit(this);
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public void printHeader(IndentedWriter out) {
        out.print("PropertyShape ");
        out.print(PathWriter.asString((Path)this.path));
    }

    @Override
    public String toString() {
        String x = "PropertyShape[" + this.getShapeNode() + " -> " + this.path + "]";
        if (this.deactivated()) {
            x = x + " deactivated";
        }
        return x;
    }
}

