/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.engine.constraint.ConstraintPairwise;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.sparql.path.Path;

public class LessThanConstraint
extends ConstraintPairwise {
    public LessThanConstraint(Node property) {
        super(property);
    }

    @Override
    public void validate(ValidationContext vCxt, Shape shape, Node focusNode, Path path, Set<Node> pathNodes, Set<Node> compareNodes) {
        for (Node vn : pathNodes) {
            for (Node v : compareNodes) {
                int r = super.compare(vn, v);
                if (r == -1) continue;
                String msg = this.toString() + ": value node " + ShLib.displayStr(vn) + " is not less than " + ShLib.displayStr(v);
                vCxt.reportEntry(msg, shape, focusNode, path, vn, this);
            }
        }
    }

    @Override
    public Node getComponent() {
        return SHACL.LessThanConstraintComponent;
    }

    public String toString() {
        return "LessThan[" + ShLib.displayStr(this.property) + "]";
    }
}

