/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.exec;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shacl.ShaclException;
import org.apache.jena.shacl.engine.Target;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.engine.constraint.ConstraintTerm;
import org.apache.jena.shacl.engine.exec.ValidationOp;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.validation.ReportItem;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.Path;

public class TripleValidator {
    private final ValidationOp validationOp;
    private final ConstraintTerm ct;
    private final Target target;

    public TripleValidator(ValidationOp validationOp) {
        this.validationOp = validationOp;
        this.ct = (ConstraintTerm)validationOp.getConstraint();
        this.target = validationOp.getTarget();
    }

    public ReportItem validate(ValidationContext vCtx, Triple triple) {
        Node focusNode = TripleValidator.focusNode(triple, this.validationOp);
        if (focusNode == null) {
            return null;
        }
        ConstraintTerm ct = (ConstraintTerm)this.validationOp.getConstraint();
        return ct.validate(vCtx, focusNode);
    }

    public static Node focusNode(Triple triple, ValidationOp validationOp) {
        Target target = validationOp.getTarget();
        switch (target.getTargetType()) {
            case targetNode: {
                return target.getObject();
            }
            case targetObjectsOf: {
                return triple.getObject();
            }
            case targetSubjectsOf: {
                Path path = validationOp.getPath();
                if (path != null) {
                    if (!(path instanceof P_Link)) {
                        throw new ShaclException("Not a predicate path: " + path);
                    }
                    return triple.getObject();
                }
                return triple.getSubject();
            }
        }
        return null;
    }

    public Shape getShape() {
        return this.validationOp.getShape();
    }

    public Path getPath() {
        return this.validationOp.getPath();
    }

    public Target getTarget() {
        return this.validationOp.getTarget();
    }

    public Node getFocusNode(Triple triple) {
        return ShLib.focusNode(triple, this.target);
    }

    public Constraint getConstraint() {
        return this.validationOp.getConstraint();
    }
}

