/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.Objects;
import java.util.Set;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.engine.constraint.SparqlValidation;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.path.Path;

public class SparqlConstraint
implements Constraint {
    private final Query query;
    private String message;
    static Var varValue = Var.alloc((String)"value");
    static Var varPath = Var.alloc((String)"path");
    static Var varPATH = Var.alloc((String)"PATH");

    public SparqlConstraint(Query query, String message) {
        this.query = query;
        this.message = message;
    }

    @Override
    public void validateNodeShape(ValidationContext vCxt, Graph data, Shape shape, Node focusNode) {
        SparqlValidation.validate(vCxt, data, shape, focusNode, null, focusNode, this.query, null, this.message, this);
    }

    @Override
    public void validatePropertyShape(ValidationContext vCxt, Graph data, Shape shape, Node focusNode, Path path, Set<Node> valueNodes) {
        valueNodes.forEach(vn -> SparqlValidation.validate(vCxt, data, shape, focusNode, path, vn, this.query, null, this.message, this));
    }

    @Override
    public Node getComponent() {
        return SHACL.SPARQLConstraintComponent;
    }

    @Override
    public void printCompact(IndentedWriter out, NodeFormatter nodeFmt) {
        Constraint.super.printCompact(out, nodeFmt);
    }

    public String toString() {
        IndentedLineBuffer out = new IndentedLineBuffer();
        out.setFlatMode(true);
        this.query.serialize(out);
        String x = out.asString();
        return "SPARQL[" + x + "]";
    }

    public int hashCode() {
        return Objects.hash(this.message, this.query);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SparqlConstraint other = (SparqlConstraint)obj;
        return Objects.equals(this.message, other.message) && Objects.equals(this.query, other.query);
    }
}

