/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.shacl.Imports;
import org.apache.jena.shacl.ShaclException;
import org.apache.jena.shacl.engine.Targets;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.parser.ShapesParser;
import org.apache.jena.sys.JenaSystem;

public class Shapes
implements Iterable<Shape> {
    private final Graph shapesGraph;
    private final Map<Node, Shape> shapes;
    private final Collection<Shape> rootShapes;
    private final Collection<Shape> declShapes;
    private final Targets targets;
    private final Node shapesBase;
    private final List<Node> imports;

    public static Shapes parse(Model model) {
        return Shapes.parse(model.getGraph());
    }

    public static Shapes parse(String fileOrURL) {
        Graph g = RDFDataMgr.loadGraph((String)fileOrURL);
        return Shapes.parse(g);
    }

    public static Shapes parse(String fileOrURL, boolean withImports) {
        Graph g = withImports ? Imports.loadWithImports(fileOrURL) : RDFDataMgr.loadGraph((String)fileOrURL);
        return Shapes.parse(g);
    }

    public static Shapes parse(Graph graph) {
        return Shapes.parseAll(graph);
    }

    public static Shapes parseTargets(Graph graph) {
        Targets targets = ShapesParser.targets(graph);
        Shapes shapes = Shapes.parseProcess(graph, targets, Collections.emptyList());
        return shapes;
    }

    private static Shapes parseAll(Graph graph) {
        Targets targets = ShapesParser.targets(graph);
        Collection<Node> declShapes = ShapesParser.findDeclaredShapes(graph);
        Shapes shapes = Shapes.parseProcess(graph, targets, declShapes);
        return shapes;
    }

    private static Shapes parseProcess(Graph shapesGraph, Targets targets, Collection<Node> declaredNodes) {
        HashMap<Node, Shape> shapesMap = new HashMap<Node, Shape>();
        Collection<Shape> rootShapes = ShapesParser.parseShapes(shapesGraph, targets, shapesMap);
        declaredNodes.forEach(shapeNode -> {
            if (!shapesMap.containsKey(shapeNode)) {
                Shape shape = ShapesParser.parseShape(shapesMap, shapesGraph, shapeNode);
            }
        });
        ArrayList<Shape> declShapes = new ArrayList<Shape>();
        declaredNodes.forEach(shapeNode -> {
            if (shapesMap.containsKey(shapeNode)) {
                Shape sh = (Shape)shapesMap.get(shapeNode);
                if (!rootShapes.contains(sh)) {
                    declShapes.add((Shape)shapesMap.get(shapeNode));
                }
            } else {
                throw new ShaclException("Failed to find shape for declared shape: " + shapeNode);
            }
        });
        return new Shapes(shapesGraph, shapesMap, targets, rootShapes, declShapes);
    }

    private Shapes(Graph shapesGraph, Map<Node, Shape> shapesMap, Targets targets, Collection<Shape> rootShapes, Collection<Shape> declShapes) {
        this.shapesGraph = shapesGraph;
        this.targets = targets;
        this.shapes = shapesMap;
        this.rootShapes = rootShapes;
        this.declShapes = declShapes;
        Pair<Node, List<Node>> pair = Imports.baseAndImports(shapesGraph);
        this.shapesBase = (Node)pair.getLeft();
        this.imports = (List)pair.getRight();
    }

    public boolean isEmpty() {
        return this.shapes.isEmpty();
    }

    public Collection<Shape> getTargetShapes() {
        return this.rootShapes;
    }

    public Collection<Node> getImports() {
        return this.imports;
    }

    public Node getBase() {
        return this.shapesBase;
    }

    public Shape getShape(Node node) {
        return this.shapes.get(node);
    }

    public Map<Node, Shape> getShapeMap() {
        return this.shapes;
    }

    public Graph getGraph() {
        return this.shapesGraph;
    }

    public Targets getTargets() {
        return this.targets;
    }

    public int numShapes() {
        return this.shapes.values().size();
    }

    public int numRootShapes() {
        return this.rootShapes.size();
    }

    @Override
    public Iterator<Shape> iterator() {
        return this.rootShapes.iterator();
    }

    public Iterator<Shape> iteratorAll() {
        return Iter.concat(this.rootShapes.iterator(), this.declShapes.iterator());
    }

    static {
        JenaSystem.init();
    }
}

