/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.parser;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.ext.com.google.common.collect.ArrayListMultimap;
import org.apache.jena.ext.com.google.common.collect.Multimap;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.other.G;
import org.apache.jena.shacl.engine.Parameter;
import org.apache.jena.shacl.engine.constraint.SparqlComponent;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.Parameters;
import org.apache.jena.shacl.vocabulary.SHACL;

public class TargetExtensions {
    Multimap<Node, SparqlComponent> paramPathToComponents = ArrayListMultimap.create();
    Set<Parameter> parameters = new HashSet<Parameter>();

    public static TargetExtensions parseSPARQLTargetType(Graph shapesGraph) {
        TargetExtensions x = new TargetExtensions();
        G.allNodesOfTypeRDFS((Graph)shapesGraph, (Node)SHACL.SPARQLTargetType).forEach(sttNode -> {
            SparqlComponent c = TargetExtensions.sparqlTargetType(shapesGraph, sttNode);
            if (c != null) {
                for (Parameter p : c.getParams()) {
                    x.paramPathToComponents.put((Object)p.getParameterPath(), (Object)c);
                    x.parameters.add(p);
                }
            }
        });
        return x;
    }

    public static SparqlComponent sparqlTargetType(Graph shapesGraph, Node sparqlTargetTypeNode) {
        List<Parameter> params = Parameters.parseParameters(shapesGraph, sparqlTargetTypeNode);
        String sparqlString = ShLib.extractSPARQLQueryString(shapesGraph, sparqlTargetTypeNode);
        return SparqlComponent.targetType(sparqlString, params);
    }

    public boolean hasParameters() {
        return !this.parameters.isEmpty();
    }
}

