/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.expressions;

import java.util.Objects;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shex.expressions.ShapeExprVisitor;
import org.apache.jena.shex.expressions.ShapeExpression;
import org.apache.jena.shex.sys.ReportItem;
import org.apache.jena.shex.sys.ValidationContext;

public class ShapeExprNOT
extends ShapeExpression {
    private final ShapeExpression other;

    public ShapeExprNOT(ShapeExpression shapeExpression) {
        this.other = shapeExpression;
    }

    @Override
    public boolean satisfies(ValidationContext vCxt, Node data) {
        ValidationContext vCxt2 = ValidationContext.create(vCxt);
        boolean innerSatisfies = this.other.satisfies(vCxt2, data);
        if (!innerSatisfies) {
            return true;
        }
        ReportItem item = new ReportItem("NOT: Term reject because it conforms", data);
        vCxt.reportEntry(item);
        return false;
    }

    public ShapeExpression subShape() {
        return this.other;
    }

    @Override
    public void visit(ShapeExprVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void print(IndentedWriter out, NodeFormatter nFmt) {
        out.print("NOT ");
        this.other.print(out, nFmt);
    }

    @Override
    public String toString() {
        return "ShapeExprNOT[" + this.other + "]";
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.other);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShapeExprNOT other = (ShapeExprNOT)obj;
        return Objects.equals(this.other, other.other);
    }
}

