/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex;

import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shex.expressions.ShapeExpression;
import org.apache.jena.shex.sys.SysShex;
import org.apache.jena.shex.sys.ValidationContext;

public class ShexShape {
    private final Node label;
    private ShapeExpression shExpression;

    public ShexShape(Node label, ShapeExpression shExpression) {
        this.label = label;
        this.shExpression = shExpression;
    }

    public Node getLabel() {
        return this.label;
    }

    public ShapeExpression getShapeExpression() {
        return this.shExpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean satisfies(ValidationContext vCxt, Node data) {
        vCxt.startValidate(this, data);
        try {
            boolean bl = this.shExpression.satisfies(vCxt, data) && this.shExpression.testShapeExprSemanticActions(vCxt, data);
            return bl;
        }
        finally {
            vCxt.finishValidate(this, data);
        }
    }

    public void print(IndentedWriter iOut, NodeFormatter nFmt) {
        iOut.printf("Shape: ", new Object[0]);
        if (SysShex.startNode.equals((Object)this.getLabel())) {
            iOut.print("START");
        } else {
            nFmt.format((AWriter)iOut, this.getLabel());
        }
        iOut.println();
        iOut.incIndent();
        this.getShapeExpression().print(iOut, nFmt);
        iOut.decIndent();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        result = 31 * result + (this.shExpression == null ? 0 : this.shExpression.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShexShape other = (ShexShape)obj;
        if (this.label == null ? other.label != null : !this.label.equals((Object)other.label)) {
            return false;
        }
        return !(this.shExpression == null ? other.shExpression != null : !this.shExpression.equals(other.shExpression));
    }

    public String toString() {
        return "ShexShape [label=" + this.label + " expr=" + this.shExpression + "]";
    }
}

