/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.store;

import java.util.Map;
import java.util.Set;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.DatasetPrefixStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetPrefixStorageLogger
implements DatasetPrefixStorage {
    private final DatasetPrefixStorage other;
    private String label = null;
    private static final Logger log = LoggerFactory.getLogger(DatasetPrefixStorage.class);

    public DatasetPrefixStorageLogger(DatasetPrefixStorage other) {
        this.other = other;
    }

    public void close() {
        this.info("close");
    }

    public void sync() {
        this.info("sync");
    }

    public Set<String> graphNames() {
        Set x = this.other.graphNames();
        this.info("graphNames:" + x);
        return x;
    }

    public String readPrefix(String graphName, String prefix) {
        String x = this.other.readPrefix(graphName, prefix);
        this.info("readPrefix(" + graphName + ", " + prefix + ") -> " + x);
        return x;
    }

    public String readByURI(String graphName, String uriStr) {
        String x = this.other.readByURI(graphName, uriStr);
        this.info("readByURI(" + graphName + ", " + uriStr + ") -> " + x);
        return x;
    }

    public Map<String, String> readPrefixMap(String graphName) {
        Map x = this.other.readPrefixMap(graphName);
        this.info("readPrefixMap(" + graphName + ") -> " + x);
        return x;
    }

    public void insertPrefix(String graphName, String prefix, String uri) {
        this.info("insertPrefix(" + graphName + ", " + prefix + ", " + uri + ")");
        this.other.insertPrefix(graphName, prefix, uri);
    }

    public void loadPrefixMapping(String graphName, PrefixMapping pmap) {
        this.info("loadPrefixMapping(" + graphName + ", " + pmap + ")");
        this.other.loadPrefixMapping(graphName, pmap);
    }

    public void removeFromPrefixMap(String graphName, String prefix) {
        this.info("removeFromPrefixMap(" + graphName + ", " + prefix + ")");
        this.other.removeFromPrefixMap(graphName, prefix);
    }

    public void removeAllFromPrefixMap(String graphName) {
        this.info("removeAllFromPrefixMap(" + graphName + ")");
        this.other.removeAllFromPrefixMap(graphName);
    }

    public PrefixMapping getPrefixMapping() {
        PrefixMapping x = this.other.getPrefixMapping();
        this.info("getPrefixMapping() -> " + x);
        return x;
    }

    public PrefixMapping getPrefixMapping(String graphName) {
        PrefixMapping x = this.other.getPrefixMapping(graphName);
        this.info("getPrefixMapping(" + graphName + ") -> " + x);
        return x;
    }

    private void info(String string) {
        if (this.label != null) {
            string = this.label + ": " + string;
        }
        log.info(string);
    }
}

