/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.transaction;

import java.util.Map;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.tdb.TDBException;
import org.apache.jena.tdb.base.block.BlockMgr;
import org.apache.jena.tdb.base.block.BlockMgrLogger;
import org.apache.jena.tdb.base.block.BlockMgrReadonly;
import org.apache.jena.tdb.base.file.FileFactory;
import org.apache.jena.tdb.base.file.FileSet;
import org.apache.jena.tdb.base.objectfile.ObjectFile;
import org.apache.jena.tdb.base.record.RecordFactory;
import org.apache.jena.tdb.index.IndexMap;
import org.apache.jena.tdb.index.IndexParams;
import org.apache.jena.tdb.setup.BlockMgrBuilder;
import org.apache.jena.tdb.setup.DatasetBuilderStd;
import org.apache.jena.tdb.setup.NodeTableBuilder;
import org.apache.jena.tdb.setup.StoreParams;
import org.apache.jena.tdb.store.DatasetGraphTDB;
import org.apache.jena.tdb.store.nodetable.NodeTable;
import org.apache.jena.tdb.store.nodetable.NodeTableInline;
import org.apache.jena.tdb.store.nodetable.NodeTableReadonly;
import org.apache.jena.tdb.sys.FileRef;
import org.apache.jena.tdb.transaction.BlockMgrJournal;
import org.apache.jena.tdb.transaction.DatasetGraphTxn;
import org.apache.jena.tdb.transaction.NodeTableTrans;
import org.apache.jena.tdb.transaction.Transaction;
import org.apache.jena.tdb.transaction.TransactionManager;

public class DatasetBuilderTxn {
    private TransactionManager txnMgr;
    private Map<FileRef, BlockMgr> blockMgrs;
    private Map<FileRef, NodeTable> nodeTables;
    private Transaction txn;
    private DatasetGraphTDB dsg;

    public DatasetBuilderTxn(TransactionManager txnMgr) {
        this.txnMgr = txnMgr;
    }

    public DatasetGraphTxn build(Transaction transaction, ReadWrite mode, DatasetGraphTDB dsg) {
        DatasetGraphTDB dsgTDB;
        this.blockMgrs = dsg.getConfig().blockMgrs;
        this.nodeTables = dsg.getConfig().nodeTables;
        this.txn = transaction;
        this.dsg = dsg;
        switch (mode) {
            case READ: {
                dsgTDB = this.buildReadonly();
                break;
            }
            case WRITE: {
                dsgTDB = this.buildWritable();
                break;
            }
            default: {
                dsgTDB = null;
            }
        }
        DatasetGraphTxn dsgTxn = new DatasetGraphTxn(dsgTDB, this.txn);
        dsgTxn.getContext().putAll(dsg.getContext());
        return dsgTxn;
    }

    private DatasetGraphTDB buildReadonly() {
        BlockMgrBuilderReadonly blockMgrBuilder = new BlockMgrBuilderReadonly();
        NodeTableBuilderReadonly nodeTableBuilder = new NodeTableBuilderReadonly();
        DatasetBuilderStd x = new DatasetBuilderStd(blockMgrBuilder, nodeTableBuilder);
        DatasetGraphTDB dsg2 = x._build(this.dsg.getLocation(), this.dsg.getConfig().params, false, this.dsg.getReorderTransform());
        return dsg2;
    }

    private DatasetGraphTDB buildWritable() {
        BlockMgrBuilderTx blockMgrBuilder = new BlockMgrBuilderTx();
        NodeTableBuilderTx nodeTableBuilder = new NodeTableBuilderTx();
        DatasetBuilderStd x = new DatasetBuilderStd(blockMgrBuilder, nodeTableBuilder);
        DatasetGraphTDB dsg2 = x._build(this.dsg.getLocation(), this.dsg.getConfig().params, true, this.dsg.getReorderTransform());
        dsg2.getContext().putAll(this.dsg.getContext());
        return dsg2;
    }

    static BlockMgrBuilder logging(BlockMgrBuilder other) {
        return new BlockMgrBuilderLogger(other);
    }

    class NodeTableBuilderReadonly
    implements NodeTableBuilder {
        NodeTableBuilderReadonly() {
        }

        @Override
        public NodeTable buildNodeTable(FileSet fsIndex, FileSet fsObjectFile, StoreParams params) {
            FileRef ref = FileRef.create(fsObjectFile.filename("dat"));
            NodeTable nt = (NodeTable)DatasetBuilderTxn.this.nodeTables.get(ref);
            nt = new NodeTableReadonly(nt);
            return nt;
        }
    }

    class BlockMgrBuilderReadonly
    implements BlockMgrBuilder {
        BlockMgrBuilderReadonly() {
        }

        @Override
        public BlockMgr buildBlockMgr(FileSet fileSet, String ext, IndexParams params) {
            FileRef ref = FileRef.create(fileSet, ext);
            BlockMgr blockMgr = (BlockMgr)DatasetBuilderTxn.this.blockMgrs.get(ref);
            if (blockMgr == null) {
                throw new TDBException("No BlockMgr for " + ref);
            }
            blockMgr = new BlockMgrReadonly(blockMgr);
            return blockMgr;
        }
    }

    class BlockMgrBuilderTx
    implements BlockMgrBuilder {
        BlockMgrBuilderTx() {
        }

        @Override
        public BlockMgr buildBlockMgr(FileSet fileSet, String ext, IndexParams params) {
            FileRef ref = FileRef.create(fileSet, ext);
            BlockMgr baseMgr = (BlockMgr)DatasetBuilderTxn.this.blockMgrs.get(ref);
            if (baseMgr == null) {
                throw new TDBException("No BlockMgr for " + ref);
            }
            BlockMgrJournal blkMgr = new BlockMgrJournal(DatasetBuilderTxn.this.txn, ref, baseMgr);
            DatasetBuilderTxn.this.txn.addComponent(blkMgr);
            return blkMgr;
        }
    }

    class NodeTableBuilderTx
    implements NodeTableBuilder {
        NodeTableBuilderTx() {
        }

        @Override
        public NodeTable buildNodeTable(FileSet fsIndex, FileSet fsObjectFile, StoreParams params) {
            FileRef ref = FileRef.create(fsObjectFile.filename("dat"));
            NodeTable ntBase = (NodeTable)DatasetBuilderTxn.this.nodeTables.get(ref);
            if (ntBase == null) {
                throw new TDBException("No NodeTable for " + ref);
            }
            RecordFactory recordFactory = new RecordFactory(16, 8);
            IndexMap idx = new IndexMap(recordFactory);
            String objFilename = fsObjectFile.filename("dat-jrnl");
            ObjectFile objectFile = fsObjectFile.isMem() ? FileFactory.createObjectFileMem(objFilename) : FileFactory.createObjectFileDisk(objFilename);
            NodeTableTrans ntt = new NodeTableTrans(DatasetBuilderTxn.this.txn, fsObjectFile.getBasename(), ntBase, idx, objectFile);
            DatasetBuilderTxn.this.txn.addComponent(ntt);
            NodeTable nt = NodeTableInline.create(ntt);
            return nt;
        }
    }

    static class BlockMgrBuilderLogger
    implements BlockMgrBuilder {
        public BlockMgrBuilder other;

        public BlockMgrBuilderLogger(BlockMgrBuilder other) {
            this.other = other;
        }

        @Override
        public BlockMgr buildBlockMgr(FileSet fileSet, String ext, IndexParams params) {
            BlockMgr blkMgr = this.other.buildBlockMgr(fileSet, ext, params);
            blkMgr = new BlockMgrLogger(blkMgr.getLabel(), blkMgr, true);
            return blkMgr;
        }
    }
}

