/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.migrate;

import org.apache.jena.query.ReadWrite;
import org.apache.jena.shared.Lock;
import org.apache.jena.tdb.transaction.DatasetGraphTransaction;
import org.apache.jena.tdb.transaction.TDBTransactionException;

public class LockTx
implements Lock {
    private DatasetGraphTransaction dsg;
    private LockTxState state = LockTxState.TxNONE;

    public LockTx(DatasetGraphTransaction dsg) {
        this.dsg = dsg;
    }

    public void enterCriticalSection(boolean readLockRequested) {
        if (this.state != LockTxState.TxNONE) {
            throw new TDBTransactionException("Illegal state: " + (Object)((Object)this.state));
        }
        if (readLockRequested) {
            this.state = LockTxState.TxREAD;
            this.dsg.begin(ReadWrite.READ);
        } else {
            this.state = LockTxState.TxWRITE;
            this.dsg.begin(ReadWrite.WRITE);
        }
    }

    public void leaveCriticalSection() {
        switch (this.state) {
            case TxNONE: {
                throw new TDBTransactionException("Illegal state: " + (Object)((Object)this.state));
            }
            case TxREAD: {
                this.dsg.close();
                break;
            }
            case TxWRITE: {
                this.dsg.commit();
            }
        }
        this.state = LockTxState.TxNONE;
    }

    static enum LockTxState {
        TxNONE,
        TxREAD,
        TxWRITE;

    }
}

