/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.assembler;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import java.io.File;
import java.io.IOException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.query.text.EntityDefinition;
import org.apache.jena.query.text.TextDatasetFactory;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.assembler.TextVocab;
import org.apache.jena.riot.system.IRILib;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;

public class TextIndexLuceneAssembler
extends AssemblerBase {
    public TextIndex open(Assembler a, Resource root, Mode mode) {
        try {
            RAMDirectory directory;
            if (!GraphUtils.exactlyOneProperty((Resource)root, (Property)TextVocab.pDirectory)) {
                throw new TextIndexException("No 'text:directory' property on " + root);
            }
            RDFNode n = root.getProperty(TextVocab.pDirectory).getObject();
            if (n.isLiteral()) {
                if (!"mem".equals(n.asLiteral().getLexicalForm())) {
                    throw new TextIndexException("No 'text:directory' property on " + root + " is a literal and not \"mem\"");
                }
                directory = new RAMDirectory();
            } else {
                Resource x = n.asResource();
                String path = IRILib.IRIToFilename((String)x.getURI());
                File dir = new File(path);
                directory = FSDirectory.open((File)dir);
            }
            Resource r = GraphUtils.getResourceValue((Resource)root, (Property)TextVocab.pEntityMap);
            EntityDefinition docDef = (EntityDefinition)a.open(r);
            return TextDatasetFactory.createLuceneIndex((Directory)directory, docDef);
        }
        catch (IOException e) {
            IO.exception((IOException)e);
            return null;
        }
    }
}

