/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.sparql.JenaTransactionException;
import com.hp.hpl.jena.sparql.core.DatasetChanges;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphMonitor;
import com.hp.hpl.jena.sparql.core.DatasetGraphWithLock;
import com.hp.hpl.jena.sparql.core.GraphView;
import com.hp.hpl.jena.sparql.core.Transactional;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.query.text.TextDocProducer;
import org.apache.jena.query.text.TextIndex;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetGraphText
extends DatasetGraphMonitor
implements Transactional {
    private static Logger log = LoggerFactory.getLogger(DatasetGraphText.class);
    private final TextIndex textIndex;
    private final Transactional dsgtxn;
    private final Graph dftGraph;
    private boolean needFinish = false;

    public DatasetGraphText(DatasetGraph dsg, TextIndex index, TextDocProducer producer) {
        super(dsg, (DatasetChanges)producer);
        this.textIndex = index;
        this.dsgtxn = dsg instanceof Transactional ? (Transactional)dsg : new DatasetGraphWithLock(dsg);
        this.dftGraph = GraphView.createDefaultGraph((DatasetGraph)this);
    }

    public Graph getDefaultGraph() {
        return this.dftGraph;
    }

    public Graph getGraph(Node graphNode) {
        return GraphView.createNamedGraph((DatasetGraph)this, (Node)graphNode);
    }

    public TextIndex getTextIndex() {
        return this.textIndex;
    }

    public Iterator<Node> search(String queryString) {
        return this.search(queryString, null);
    }

    public Iterator<Node> search(String queryString, Node predicate) {
        return this.search(queryString, predicate, -1);
    }

    public Iterator<Node> search(String queryString, int limit) {
        return this.search(queryString, null, limit);
    }

    public Iterator<Node> search(String queryString, Node predicate, int limit) {
        queryString = QueryParserBase.escape((String)queryString);
        if (predicate != null) {
            String f = this.textIndex.getDocDef().getField(predicate);
            queryString = f + ":" + queryString;
        }
        List<Node> results = this.textIndex.query(queryString, limit);
        return results.iterator();
    }

    public void begin(ReadWrite readWrite) {
        this.dsgtxn.begin(readWrite);
        if (readWrite == ReadWrite.WRITE) {
            super.getMonitor().start();
            this.needFinish = true;
        }
    }

    public void commit() {
        try {
            if (this.needFinish) {
                super.getMonitor().finish();
            }
            this.needFinish = false;
            this.dsgtxn.commit();
        }
        catch (Throwable ex) {
            log.warn("Exception in commit: " + ex.getMessage(), ex);
            this.dsgtxn.abort();
        }
    }

    public void abort() {
        try {
            if (this.needFinish) {
                this.textIndex.abortIndexing();
            }
            this.dsgtxn.abort();
        }
        catch (JenaTransactionException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            log.warn("Exception in abort: " + ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    public boolean isInTransaction() {
        return this.dsgtxn.isInTransaction();
    }

    public void end() {
        try {
            this.dsgtxn.end();
        }
        catch (Throwable ex) {
            log.warn("Exception in end: " + ex.getMessage(), ex);
        }
    }
}

