/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.jena.atlas.lib.MultiMap;
import org.apache.lucene.analysis.Analyzer;

public class EntityDefinition {
    private final Map<Node, String> predicateToField = new HashMap<Node, String>();
    private final Map<String, Analyzer> fieldToAnalyzer = new HashMap<String, Analyzer>();
    private final MultiMap<String, Node> fieldToPredicate = MultiMap.createMapList();
    private final Collection<String> fields = Collections.unmodifiableCollection(this.fieldToPredicate.keys());
    private final String entityField;
    private final String primaryField;
    private final String graphField;

    public EntityDefinition(String entityField, String primaryField) {
        this(entityField, primaryField, (String)null);
    }

    public EntityDefinition(String entityField, String primaryField, String graphField) {
        this.entityField = entityField;
        this.primaryField = primaryField;
        this.graphField = graphField;
    }

    public EntityDefinition(String entityField, String primaryField, Resource primaryPredicate) {
        this(entityField, primaryField, null, primaryPredicate.asNode());
    }

    public EntityDefinition(String entityField, String primaryField, Node primaryPredicate) {
        this(entityField, primaryField, null, primaryPredicate);
    }

    public EntityDefinition(String entityField, String primaryField, String graphField, Node primaryPredicate) {
        this(entityField, primaryField, graphField);
        this.set(primaryField, primaryPredicate);
    }

    public String getEntityField() {
        return this.entityField;
    }

    public void set(String field, Node predicate) {
        this.predicateToField.put(predicate, field);
        Collection c = this.fieldToPredicate.get((Object)field);
        if (c == null || !c.contains(predicate)) {
            this.fieldToPredicate.put((Object)field, (Object)predicate);
        }
    }

    public Collection<Node> getPredicates(String field) {
        return this.fieldToPredicate.get((Object)field);
    }

    public String getField(Node predicate) {
        return this.predicateToField.get(predicate);
    }

    public void setAnalyzer(String field, Analyzer analyzer) {
        this.fieldToAnalyzer.put(field, analyzer);
    }

    public Analyzer getAnalyzer(String field) {
        return this.fieldToAnalyzer.get(field);
    }

    public String getPrimaryField() {
        return this.primaryField;
    }

    public Node getPrimaryPredicate() {
        Collection c = this.fieldToPredicate.get((Object)this.getPrimaryField());
        return (Node)EntityDefinition.getOne(c);
    }

    public String getGraphField() {
        return this.graphField;
    }

    public Collection<String> fields() {
        return this.fields;
    }

    private static <T> T getOne(Collection<T> collection) {
        if (collection.size() != 1) {
            return null;
        }
        return collection.iterator().next();
    }

    public String toString() {
        return this.entityField + ":" + this.predicateToField;
    }
}

