/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.DatasetChangesBatched;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadAction;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import java.util.List;
import org.apache.jena.query.text.Entity;
import org.apache.jena.query.text.EntityDefinition;
import org.apache.jena.query.text.TextDocProducer;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.TextQueryFuncs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextDocProducerEntities
extends DatasetChangesBatched
implements TextDocProducer {
    private static Logger log = LoggerFactory.getLogger(TextDocProducer.class);
    private final EntityDefinition defn;
    private final TextIndex indexer;
    private boolean started = false;

    public TextDocProducerEntities(EntityDefinition defn, TextIndex indexer) {
        this.defn = defn;
        this.indexer = indexer;
    }

    protected void startBatched() {
        this.indexer.startIndexing();
        this.started = true;
    }

    protected void finishBatched() {
        this.indexer.finishIndexing();
    }

    protected void dispatch(QuadAction quadAction, List<Quad> batch) {
        if (!this.started) {
            throw new IllegalStateException("Not started");
        }
        if (!QuadAction.ADD.equals((Object)quadAction)) {
            return;
        }
        if (batch.size() == 0) {
            return;
        }
        this.docQuads(batch);
    }

    private void docEntity(Node g, Node s, List<Quad> batch) {
        String x = TextQueryFuncs.subjectToString(s);
        String gx = TextQueryFuncs.graphNodeToString(g);
        Entity entity = new Entity(x, gx);
        String graphField = this.defn.getGraphField();
        if (this.defn.getGraphField() != null) {
            entity.put(graphField, gx);
        }
        for (Quad quad : batch) {
            Node p = quad.getPredicate();
            String field = this.defn.getField(p);
            if (field == null) continue;
            Node o = quad.getObject();
            String val = null;
            if (o.isURI()) {
                val = o.getURI();
            } else if (o.isLiteral()) {
                val = o.getLiteralLexicalForm();
            } else {
                log.warn("Not a literal value for mapped field-predicate: " + field + " :: " + FmtUtils.stringForString((String)field));
                continue;
            }
            entity.put(field, val);
        }
        this.indexer.addEntity(entity);
    }

    private void docQuads(List<Quad> batch) {
        for (Quad quad : batch) {
            Entity entity = TextQueryFuncs.entityFromQuad(this.defn, quad);
            if (entity == null) continue;
            this.indexer.addEntity(entity);
        }
    }
}

